/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.DaggerItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Scout
extends AbstractHumanCompanionEntity {
    private static final ResourceLocation SPEED_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"scout_speed");

    public Scout(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.35, true));
        this.boostBaseSpeed();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.maintainAgilityEffects();
            this.checkDagger();
        }
        super.tick();
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        LivingEntity living;
        boolean hit = super.doHurtTarget(entity);
        if (!this.level().isClientSide() && entity instanceof LivingEntity && (this.isBackstab(living = (LivingEntity)entity) || this.focusedElsewhere(living))) {
            living.hurt(this.damageSources().mobAttack((LivingEntity)this), 3.0f);
        }
        return hit;
    }

    public boolean causeFallDamage(float distance, float multiplier, DamageSource source) {
        return super.causeFallDamage(distance, multiplier * 0.5f, source);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.STONE_SWORD.getDefaultInstance());
            this.checkDagger();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    private void boostBaseSpeed() {
        AttributeInstance speed = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speed != null && speed.getModifier(SPEED_MOD) == null) {
            speed.addPermanentModifier(new AttributeModifier(SPEED_MOD, 0.05, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void maintainAgilityEffects() {
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 0, true, false));
        this.addEffect(new MobEffectInstance(MobEffects.JUMP, 60, 0, true, false));
    }

    private void checkDagger() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!(stack.getItem() instanceof DaggerItem) && !stack.is(Items.STONE_SWORD) && !stack.is(Items.IRON_SWORD) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
    }

    private boolean isBackstab(LivingEntity target) {
        Vec3 look;
        Vec3 toAttacker = this.position().subtract(target.position()).normalize();
        return toAttacker.dot(look = target.getLookAngle().normalize()) < -0.25;
    }

    private boolean focusedElsewhere(LivingEntity target) {
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            return mob.getTarget() != this;
        }
        return false;
    }
}

