/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.GlaiveItem;
import com.majorbonghits.moderncompanions.item.SpearItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Stormcaller
extends AbstractHumanCompanionEntity {
    private int lightningCooldown;

    public Stormcaller(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.05, true));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkTrident();
            if (this.lightningCooldown > 0) {
                --this.lightningCooldown;
            }
        }
        super.tick();
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        boolean hit = super.doHurtTarget(entity);
        if (!this.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.tryCallLightning(living);
        }
        return hit;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.TRIDENT.getDefaultInstance());
            this.checkTrident();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    private void checkTrident() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!stack.is(Items.TRIDENT) && !(stack.getItem() instanceof SpearItem) && !(stack.getItem() instanceof GlaiveItem) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
    }

    private void tryCallLightning(LivingEntity target) {
        if (this.lightningCooldown > 0) {
            return;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)server);
        if (bolt == null) {
            return;
        }
        bolt.moveTo(target.getX(), target.getY(), target.getZ());
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            bolt.setCause(sp);
        }
        server.addFreshEntity((Entity)bolt);
        float bonus = server.isThundering() || server.isRaining() ? 4.0f : 0.0f;
        target.hurt(server.damageSources().lightningBolt(), 6.0f + bonus);
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 0, true, true));
        this.lightningCooldown = server.isThundering() ? 100 : 160;
    }
}

