/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SummonedWitherSkeleton
extends WitherSkeleton {
    private static final String KEY_OWNER = "Summoner";
    private static final String KEY_LIFETIME = "Lifetime";
    private UUID ownerId;
    private int lifetimeTicks = 1200;

    public SummonedWitherSkeleton(EntityType<? extends WitherSkeleton> type, Level level) {
        super(type, level);
        this.xpReward = 0;
        this.setPersistenceRequired();
    }

    public void tick() {
        LivingEntity owner;
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (--this.lifetimeTicks <= 0) {
            this.discard();
            return;
        }
        if (this.getTarget() != null && this.isFriendlyTo((Entity)this.getTarget())) {
            this.setTarget(null);
        }
        if (this.tickCount % 20 == 0 && (owner = this.getSummoner()) != null) {
            LivingEntity nearby;
            LivingEntity ownersTarget = owner.getLastHurtMob();
            if (ownersTarget != null && this.canAttack(ownersTarget)) {
                this.setTarget(ownersTarget);
            } else if (!(this.getTarget() != null && this.getTarget().isAlive() || (nearby = this.level().getNearestEntity(LivingEntity.class, TargetingConditions.forCombat().ignoreLineOfSight().selector(this::canAttack), (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(12.0))) == null)) {
                this.setTarget(nearby);
            }
        }
        if ((owner = this.getSummoner()) != null) {
            double dist = this.distanceToSqr((Entity)owner);
            double followRange = 28.0;
            double hardRange = 52.0;
            if (dist > followRange * followRange) {
                this.getNavigation().moveTo((Entity)owner, 1.25);
            }
            if (dist > hardRange * hardRange) {
                this.teleportTo(owner.getX(), owner.getY(), owner.getZ());
            }
        }
    }

    public boolean isAlliedTo(Entity other) {
        if (this.isFriendlyTo(other)) {
            return true;
        }
        return super.isAlliedTo(other);
    }

    public boolean canAttack(LivingEntity target) {
        if (this.isFriendlyTo((Entity)target)) {
            return false;
        }
        return super.canAttack(target);
    }

    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void configureSummon(@Nullable LivingEntity owner, int lifetimeSeconds) {
        this.ownerId = owner != null ? owner.getUUID() : null;
        this.lifetimeTicks = Math.max(20, lifetimeSeconds * 20);
        if (this.getAttribute(Attributes.MAX_HEALTH) != null) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(4.0);
            this.setHealth(4.0f);
        }
        if (this.getAttribute(Attributes.ATTACK_DAMAGE) != null) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.0);
        }
        this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, this.lifetimeTicks, 0, true, false));
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.lifetimeTicks, 0, true, false));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.setDropChance(slot, 0.0f);
        }
    }

    @Nullable
    public LivingEntity getSummoner() {
        LivingEntity living;
        Level level;
        if (this.ownerId == null || !((level = this.level()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        Entity entity = server.getEntity(this.ownerId);
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public boolean isFriendlyTo(Entity other) {
        AbstractHumanCompanionEntity companion;
        if (other == null) {
            return false;
        }
        if (this.ownerId != null && this.ownerId.equals(other.getUUID())) {
            return true;
        }
        if (other instanceof SummonedWitherSkeleton) {
            SummonedWitherSkeleton summoned = (SummonedWitherSkeleton)other;
            return summoned.ownerId != null && summoned.ownerId.equals(this.ownerId);
        }
        if (other instanceof AbstractHumanCompanionEntity && (companion = (AbstractHumanCompanionEntity)other).getOwnerUUID() != null) {
            return this.ownerId != null && this.ownerId.equals(companion.getOwnerUUID());
        }
        if (other instanceof TamableAnimal) {
            TamableAnimal tam = (TamableAnimal)other;
            return this.ownerId != null && this.ownerId.equals(tam.getOwnerUUID());
        }
        LivingEntity owner = this.getSummoner();
        return owner != null && other.isAlliedTo((Entity)owner);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerId != null) {
            tag.putUUID(KEY_OWNER, this.ownerId);
        }
        tag.putInt(KEY_LIFETIME, this.lifetimeTicks);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID(KEY_OWNER)) {
            this.ownerId = tag.getUUID(KEY_OWNER);
        }
        this.lifetimeTicks = tag.getInt(KEY_LIFETIME);
    }

    public ItemStack getPickedResult(HitResult target) {
        return ItemStack.EMPTY;
    }
}

