/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.entity.Knight;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Vanguard
extends Knight {
    private static final ResourceLocation KB_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"vanguard_kb");
    private static final ResourceLocation HEALTH_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"vanguard_health");
    private static final int SHIELD_DISABLE_TICKS = 60;
    private static final int PROJECTILE_MEMORY_TICKS = 80;
    private static final int MIN_BLOCK_WINDOW = 12;
    private int auraTicker;
    private int tauntTicker;
    private int shieldCooldownTicks;
    private int projectileThreatTicks;
    private int minBlockTicks;

    public Vanguard(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.95, true));
        this.boostDefenseStats();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkSword();
            this.checkShield();
            this.tickDefenseAura();
            this.tickTaunt();
            this.tickShieldUse();
        }
        super.tick();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        LivingEntity attacker;
        ItemStack weapon;
        Entity entity;
        float adjusted = amount;
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            adjusted *= 0.7f;
            this.projectileThreatTicks = 80;
        }
        if (this.isShieldRaised() && (entity = source.getDirectEntity()) instanceof LivingEntity && (weapon = (attacker = (LivingEntity)entity).getMainHandItem()).getItem() instanceof AxeItem) {
            this.shieldCooldownTicks = 60;
            this.stopUsingShield();
        }
        return super.hurt(source, adjusted);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            ItemStack sword = this.getSpawnSword();
            ItemStack shield = Items.SHIELD.getDefaultInstance();
            this.inventory.setItem(4, sword);
            this.inventory.setItem(5, shield);
            this.checkSword();
            this.checkShield();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.checkShield();
    }

    private void boostDefenseStats() {
        AttributeInstance health;
        AttributeInstance kb = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (kb != null && kb.getModifier(KB_MOD) == null) {
            kb.addPermanentModifier(new AttributeModifier(KB_MOD, 0.35, AttributeModifier.Operation.ADD_VALUE));
        }
        if ((health = this.getAttribute(Attributes.MAX_HEALTH)) != null && health.getModifier(HEALTH_MOD) == null) {
            health.addPermanentModifier(new AttributeModifier(HEALTH_MOD, 4.0, AttributeModifier.Operation.ADD_VALUE));
            this.setHealth(this.getMaxHealth());
        }
    }

    private void checkShield() {
        ItemStack offhand = this.getItemBySlot(EquipmentSlot.OFFHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!stack.is(Items.SHIELD) || !offhand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
            offhand = stack;
        }
    }

    private void tickShieldUse() {
        if (this.shieldCooldownTicks > 0) {
            --this.shieldCooldownTicks;
        }
        if (this.projectileThreatTicks > 0) {
            --this.projectileThreatTicks;
        }
        if (this.minBlockTicks > 0) {
            --this.minBlockTicks;
        }
        if (this.isEating()) {
            this.stopUsingShield();
            return;
        }
        if (!this.getItemBySlot(EquipmentSlot.OFFHAND).is(Items.SHIELD)) {
            this.stopUsingShield();
            return;
        }
        boolean shouldBlock = this.shieldCooldownTicks <= 0 && this.shouldRaiseShield();
        boolean blocking = this.isShieldRaised();
        if (shouldBlock && !blocking) {
            this.startUsingItem(InteractionHand.OFF_HAND);
            this.minBlockTicks = 12;
        } else if (!shouldBlock && blocking && this.minBlockTicks <= 0) {
            this.stopUsingShield();
        }
    }

    private boolean shouldRaiseShield() {
        boolean inMelee;
        boolean recentProjectile;
        LivingEntity target = this.getTarget();
        boolean bl = recentProjectile = this.projectileThreatTicks > 0;
        if (target == null || !target.isAlive()) {
            return recentProjectile;
        }
        double distSq = this.distanceToSqr((Entity)target);
        boolean hasLine = this.getSensing().hasLineOfSight((Entity)target);
        boolean targetRanged = target instanceof RangedAttackMob || target.getMainHandItem().getItem() instanceof ProjectileWeaponItem || target.getOffhandItem().getItem() instanceof ProjectileWeaponItem;
        boolean closingGap = distSq > 9.0 && hasLine;
        boolean lowHealth = this.getHealth() < this.getMaxHealth() * 0.6f && hasLine;
        boolean bl2 = inMelee = distSq < 6.25 && !targetRanged && !recentProjectile;
        if (inMelee) {
            return false;
        }
        return targetRanged || closingGap || lowHealth || recentProjectile;
    }

    private boolean isShieldRaised() {
        return this.isUsingItem() && this.getUseItem().is(Items.SHIELD);
    }

    private void stopUsingShield() {
        if (this.isShieldRaised()) {
            this.stopUsingItem();
        }
    }

    private void tickDefenseAura() {
        if (++this.auraTicker % 40 != 0) {
            return;
        }
        if (this.level().isClientSide()) {
            return;
        }
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(6.0), this::isAlly).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 0, true, true));
                Level patt0$temp = this.level();
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)patt0$temp;
                    if (this.level().random.nextBoolean()) {
                        server.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, living.getX(), living.getY() + 1.1, living.getZ(), 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
        });
    }

    private void tickTaunt() {
        if (++this.tauntTicker % 30 != 0) {
            return;
        }
        if (!(this.level() instanceof ServerLevelAccessor) || this.getOwner() == null) {
            return;
        }
        LivingEntity owner = this.getOwner();
        this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(12.0), mob -> mob.getTarget() == owner && mob instanceof Monster).forEach(mob -> mob.setTarget((LivingEntity)this));
    }

    private boolean isAlly(Entity entity) {
        if (entity == this) {
            return false;
        }
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
            return companion.getOwner() != null && this.getOwner() != null && companion.getOwner() == this.getOwner();
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.isTame() && this.getOwner() != null && this.getOwner().equals((Object)tamable.getOwner());
        }
        return entity == this.getOwner();
    }
}

