/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class ArbalistCrossbowAttackGoal<T extends AbstractHumanCompanionEntity>
extends Goal {
    private static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
    private final T mob;
    private CrossbowState state = CrossbowState.UNCHARGED;
    private final double speed;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public ArbalistCrossbowAttackGoal(T mob, double speed, float radius) {
        this.mob = mob;
        this.speed = speed;
        this.attackRadiusSqr = radius * radius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.hasValidTarget() && this.isHoldingCrossbow();
    }

    public boolean canContinueToUse() {
        return this.hasValidTarget() && (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingCrossbow();
    }

    private boolean hasValidTarget() {
        return this.mob.getTarget() != null && this.mob.getTarget().isAlive();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.isHolding(is -> is.getItem() instanceof CrossbowItem);
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.state = CrossbowState.UNCHARGED;
        if (this.mob.isUsingItem()) {
            this.mob.stopUsingItem();
            ((CrossbowAttackMob)this.mob).setChargingCrossbow(false);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean pathNeeded;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)target);
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        double dist = this.mob.distanceToSqr((Entity)target);
        boolean bl = pathNeeded = (dist > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (pathNeeded) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.getNavigation().moveTo((Entity)target, this.canRun() ? this.speed : this.speed * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.mob.getRandom());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.getNavigation().stop();
        }
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (this.state == CrossbowState.UNCHARGED) {
            if (!pathNeeded) {
                this.mob.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                this.state = CrossbowState.CHARGING;
                ((CrossbowAttackMob)this.mob).setChargingCrossbow(true);
            }
        } else if (this.state == CrossbowState.CHARGING) {
            ItemStack stack;
            int using;
            if (!this.mob.isUsingItem()) {
                this.state = CrossbowState.UNCHARGED;
            }
            if ((using = this.mob.getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(stack = this.mob.getUseItem()), this.mob)) {
                this.mob.releaseUsingItem();
                this.state = CrossbowState.CHARGED;
                this.attackDelay = 20 + this.mob.getRandom().nextInt(20);
                ((CrossbowAttackMob)this.mob).setChargingCrossbow(false);
            }
        } else if (this.state == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.state = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.state == CrossbowState.READY_TO_ATTACK && canSee) {
            ((CrossbowAttackMob)this.mob).performCrossbowAttack(this.mob, 1.6f);
            this.state = CrossbowState.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.state == CrossbowState.UNCHARGED;
    }

    private static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

