/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class ArcherRangedBowAttackGoal<T extends AbstractHumanCompanionEntity>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private int seeTime;
    private int attackTime = -1;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public ArcherRangedBowAttackGoal(T mob, double speed, int interval, float radius) {
        this.mob = mob;
        this.speedModifier = speed;
        this.attackIntervalMin = interval;
        this.attackRadiusSqr = radius * radius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.isHoldingBow();
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingBow();
    }

    private boolean isHoldingBow() {
        return this.mob.isHolding(stack -> stack.getItem() instanceof BowItem);
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.stopUsingItem();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean seenLastTick;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        double distanceSqr = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
        boolean hasLineOfSight = this.mob.getSensing().hasLineOfSight((Entity)target);
        boolean bl = seenLastTick = this.seeTime > 0;
        if (hasLineOfSight != seenLastTick) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        if (!(distanceSqr > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
            this.mob.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.mob.getNavigation().moveTo((Entity)target, this.speedModifier);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (distanceSqr > (double)(this.attackRadiusSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (distanceSqr < (double)(this.attackRadiusSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.lookAt((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.mob.isUsingItem()) {
            int ticksUsing;
            if (!hasLineOfSight && this.seeTime < -60) {
                this.mob.stopUsingItem();
            } else if (hasLineOfSight && (ticksUsing = this.mob.getTicksUsingItem()) >= 20) {
                ItemStack bow = this.mob.getUseItem();
                float power = bow.getItem() instanceof BowItem ? BowItem.getPowerForTime((int)ticksUsing) : 1.0f;
                this.mob.stopUsingItem();
                ((RangedAttackMob)this.mob).performRangedAttack(target, power);
                this.attackTime = this.attackIntervalMin;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            this.mob.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
        }
    }
}

