/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class CustomFollowOwnerGoal
extends Goal {
    private static final double TELEPORT_DISTANCE_SQ = 1225.0;
    private static final int TELEPORT_ATTEMPTS = 10;
    private static final int TELEPORT_RANGE = 3;
    private final AbstractHumanCompanionEntity companion;
    private final double speedModifier;
    private final float startDistance;
    private final float stopDistance;
    private final boolean teleport;
    private LivingEntity owner;
    private int timeToRecalc;

    public CustomFollowOwnerGoal(AbstractHumanCompanionEntity companion, double speed, float startDist, float stopDist, boolean teleport) {
        this.companion = companion;
        this.speedModifier = speed;
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.teleport = teleport;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.companion.isFollowing() || this.companion.isOrderedToSit()) {
            return false;
        }
        LivingEntity livingentity = this.companion.getOwner();
        if (livingentity == null || livingentity.isSpectator() || livingentity.level() != this.companion.level()) {
            return false;
        }
        if (this.companion.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        return this.owner != null && !this.companion.getNavigation().isDone() && this.companion.isFollowing() && !this.companion.isOrderedToSit() && this.owner.level() == this.companion.level() && this.companion.distanceToSqr((Entity)this.owner) > (double)(this.stopDistance * this.stopDistance);
    }

    public void stop() {
        this.owner = null;
        this.companion.getNavigation().stop();
    }

    public void tick() {
        if (this.owner == null) {
            return;
        }
        if (this.owner.level() != this.companion.level()) {
            return;
        }
        this.companion.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.companion.getMaxHeadXRot());
        if (--this.timeToRecalc <= 0) {
            this.timeToRecalc = 10;
            double distanceSq = this.companion.distanceToSqr((Entity)this.owner);
            if (distanceSq >= 1225.0 && this.teleport) {
                if (!this.tryTeleportCloseToOwner()) {
                    this.companion.getNavigation().moveTo((Entity)this.owner, this.speedModifier);
                }
            } else {
                this.companion.getNavigation().moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private boolean tryTeleportCloseToOwner() {
        BlockPos ownerPos = this.owner.blockPosition();
        for (int attempt = 0; attempt < 10; ++attempt) {
            int dz;
            int dx = this.randomBetween(-3, 3);
            BlockPos targetPos = ownerPos.offset(dx, 0, dz = this.randomBetween(-3, 3));
            if (!this.isTeleportFriendly(targetPos)) continue;
            this.companion.teleportTo((double)targetPos.getX() + 0.5, targetPos.getY(), (double)targetPos.getZ() + 0.5);
            this.companion.getNavigation().stop();
            return true;
        }
        return false;
    }

    private boolean isTeleportFriendly(BlockPos pos) {
        return this.companion.level().isEmptyBlock(pos) && this.companion.level().isEmptyBlock(pos.above()) && this.companion.level().noCollision((Entity)this.companion, this.companion.getBoundingBox().move((double)pos.getX() - this.companion.getX(), (double)pos.getY() - this.companion.getY(), (double)pos.getZ() - this.companion.getZ()));
    }

    private int randomBetween(int min, int max) {
        return this.companion.getRandom().nextInt(max - min + 1) + min;
    }
}

