/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.core.ModConfig;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class CustomOwnerHurtByTargetGoal
extends TargetGoal {
    private final TamableAnimal companion;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public CustomOwnerHurtByTargetGoal(TamableAnimal animal) {
        super((Mob)animal, false);
        this.companion = animal;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.companion.isTame() && !this.companion.isOrderedToSit()) {
            TamableAnimal tame;
            LivingEntity owner = this.companion.getOwner();
            if (owner == null) {
                return false;
            }
            this.ownerLastHurtBy = owner.getLastHurtByMob();
            LivingEntity livingEntity = this.ownerLastHurtBy;
            if (livingEntity instanceof TamableAnimal && (tame = (TamableAnimal)livingEntity).isTame() && tame.getOwner() == this.companion.getOwner() && !((Boolean)ModConfig.safeGet(ModConfig.FRIENDLY_FIRE_COMPANIONS)).booleanValue()) {
                return false;
            }
            int i = owner.getLastHurtByMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && this.companion.wantsToAttack(this.ownerLastHurtBy, owner);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        LivingEntity owner = this.companion.getOwner();
        if (owner != null) {
            this.timestamp = owner.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

