/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class EatGoal
extends Goal {
    protected final AbstractHumanCompanionEntity companion;
    private ItemStack food = ItemStack.EMPTY;
    private int useTicks;

    public EatGoal(AbstractHumanCompanionEntity entity) {
        this.companion = entity;
    }

    public boolean canUse() {
        if (this.companion.getHealth() >= this.companion.getMaxHealth()) {
            return false;
        }
        this.food = this.companion.checkFood();
        return !this.food.isEmpty();
    }

    public void start() {
        this.companion.setItemSlot(EquipmentSlot.OFFHAND, this.food);
        this.companion.startUsingItem(InteractionHand.OFF_HAND);
        this.companion.setEating(true);
        this.useTicks = this.food.getUseDuration((LivingEntity)this.companion);
        if (this.useTicks <= 0) {
            this.useTicks = 32;
        }
        this.companion.swing(InteractionHand.OFF_HAND, true);
    }

    public void stop() {
        this.companion.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        this.companion.setEating(false);
        this.useTicks = 0;
    }

    public void tick() {
        if (this.companion.getHealth() >= this.companion.getMaxHealth()) {
            this.stop();
            return;
        }
        this.food = this.companion.checkFood();
        if (this.food.isEmpty()) {
            this.stop();
            return;
        }
        if (this.useTicks > 0) {
            --this.useTicks;
            if (this.useTicks % 4 == 0) {
                this.companion.swing(InteractionHand.OFF_HAND, true);
            }
        }
        if (this.useTicks <= 0) {
            if (this.companion.healFromFoodStack(this.food)) {
                this.useTicks = this.food.getUseDuration((LivingEntity)this.companion);
                if (this.useTicks <= 0) {
                    this.useTicks = 32;
                }
                this.companion.startUsingItem(InteractionHand.OFF_HAND);
            } else {
                this.stop();
            }
        }
    }
}

