/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.Beastmaster;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public class FollowBeastmasterGoal
extends Goal {
    private final Mob pet;
    private final Beastmaster master;
    private final PathNavigation navigation;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    private int timeToRecalcPath;
    private int postCombatHoldTicks;

    public FollowBeastmasterGoal(Mob pet, Beastmaster master, double speedModifier, float startDistance, float stopDistance) {
        this.pet = pet;
        this.master = master;
        this.navigation = pet.getNavigation();
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.master.isAlive()) {
            return false;
        }
        double dist = this.pet.distanceToSqr((Entity)this.master);
        return dist > (double)(this.startDistance * this.startDistance);
    }

    public boolean canContinueToUse() {
        if (!this.master.isAlive()) {
            return false;
        }
        double dist = this.pet.distanceToSqr((Entity)this.master);
        return dist > (double)(this.stopDistance * this.stopDistance) && !this.navigation.isDone();
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.navigation.stop();
    }

    public void tick() {
        if (this.isActivelyAttacking()) {
            this.postCombatHoldTicks = 30;
            return;
        }
        if (this.postCombatHoldTicks > 0) {
            --this.postCombatHoldTicks;
            return;
        }
        this.pet.getLookControl().setLookAt((Entity)this.master, 10.0f, (float)this.pet.getMaxHeadXRot());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        double dist = this.pet.distanceToSqr((Entity)this.master);
        if (dist >= 144.0) {
            this.tryTeleportCloseToOwner();
            return;
        }
        this.navigation.moveTo((Entity)this.master, this.speedModifier);
    }

    private boolean isActivelyAttacking() {
        return this.pet.getTarget() != null && this.pet.getTarget().isAlive();
    }

    private void tryTeleportCloseToOwner() {
        BlockPos masterPos = this.master.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int dz;
            int dx = this.randomBetween(-3, 3);
            BlockPos pos = masterPos.offset(dx, 0, dz = this.randomBetween(-3, 3));
            if (!this.isTeleportFriendly(pos)) continue;
            this.pet.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            this.navigation.stop();
            return;
        }
    }

    private boolean isTeleportFriendly(BlockPos pos) {
        return this.pet.level().isEmptyBlock(pos) && this.pet.level().isEmptyBlock(pos.above()) && this.pet.level().noCollision((Entity)this.pet, this.pet.getBoundingBox().move((double)pos.getX() - this.pet.getX(), (double)pos.getY() - this.pet.getY(), (double)pos.getZ() - this.pet.getZ()));
    }

    private int randomBetween(int min, int max) {
        return this.pet.getRandom().nextInt(max - min + 1) + min;
    }
}

