/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.magic.AbstractMageCompanion;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class MageRangedAttackGoal<T extends AbstractMageCompanion>
extends Goal {
    private final T caster;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final float preferredMinRange = 12.0f;
    private final int baseLightInterval;
    private int attackTime = -1;
    private int seeTime;
    private int strafeTime = -1;
    private boolean strafeClockwise;

    public MageRangedAttackGoal(T caster, double speed, int lightInterval, float attackRadius) {
        this.caster = caster;
        this.speedModifier = speed;
        this.baseLightInterval = lightInterval;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.caster.getTarget() != null;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.caster.getNavigation().isDone();
    }

    public void stop() {
        super.stop();
        this.caster.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.caster.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.caster.getTarget();
        if (target == null) {
            return;
        }
        double distSqr = this.caster.distanceToSqr((Entity)target);
        boolean hasLineOfSight = this.caster.getSensing().hasLineOfSight((Entity)target);
        boolean seenLastTick = this.seeTime > 0;
        int n = this.seeTime = hasLineOfSight ? this.seeTime + 1 : this.seeTime - 1;
        if (hasLineOfSight != seenLastTick) {
            this.seeTime = 0;
        }
        if (distSqr > (double)this.attackRadiusSqr || this.seeTime < 5) {
            this.caster.getNavigation().moveTo((Entity)target, this.speedModifier);
        } else {
            this.caster.getNavigation().stop();
            ++this.strafeTime;
        }
        if (distSqr < 144.0) {
            double dx = this.caster.getX() - target.getX();
            double dz = this.caster.getZ() - target.getZ();
            double len = Math.max(0.001, Math.sqrt(dx * dx + dz * dz));
            double awayX = this.caster.getX() + dx / len * 1.8;
            double awayZ = this.caster.getZ() + dz / len * 1.8;
            this.caster.getNavigation().moveTo(awayX, this.caster.getY(), awayZ, this.speedModifier);
        }
        if (this.strafeTime >= 20) {
            if ((double)this.caster.getRandom().nextFloat() < 0.3) {
                this.strafeClockwise = !this.strafeClockwise;
            }
            this.strafeTime = 0;
        }
        float distance = Mth.sqrt((float)((float)distSqr));
        float normalizedDistance = distance / Mth.sqrt((float)this.attackRadiusSqr);
        float clamped = Mth.clamp((float)normalizedDistance, (float)0.1f, (float)1.0f);
        this.caster.getLookControl().setLookAt((Entity)target, 45.0f, 45.0f);
        this.caster.setYHeadRot(this.caster.getYRot());
        if (--this.attackTime <= 0) {
            if (!hasLineOfSight) {
                this.attackTime = this.baseLightInterval;
                return;
            }
            boolean heavy = ((AbstractMageCompanion)((Object)this.caster)).tryHeavyAttack(target, clamped);
            if (!heavy) {
                this.caster.performRangedAttack(target, clamped);
            }
            int interval = ((AbstractMageCompanion)((Object)this.caster)).getLightIntervalTicks();
            this.attackTime = Math.max(10, interval);
        } else if (this.attackTime < 0) {
            this.attackTime = this.baseLightInterval;
        }
    }
}

