/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.ai;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class PatrolGoal
extends RandomStrollGoal {
    protected final float probability;
    public Vec3 patrolVec;
    public AbstractHumanCompanionEntity companion;
    public int radius;

    public PatrolGoal(AbstractHumanCompanionEntity mob, int interval, int radius) {
        this(mob, 1.0, 0.001f, interval, radius);
    }

    public PatrolGoal(AbstractHumanCompanionEntity mob, double speed, float probability, int interval, int radius) {
        super((PathfinderMob)mob, speed);
        this.probability = probability;
        this.companion = mob;
        this.interval = interval;
        this.radius = radius;
    }

    public boolean canUse() {
        if (this.companion.getPatrolPos().isEmpty() || !this.companion.isPatrolling()) {
            return false;
        }
        this.patrolVec = Vec3.atBottomCenterOf((Vec3i)((Vec3i)this.companion.getPatrolPos().orElse(this.companion.blockPosition())));
        return super.canUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        double distance;
        Vec3 vec = this.getRawPosition();
        if (vec != null && (distance = vec.distanceTo(this.patrolVec)) > (double)this.radius) {
            vec = null;
        }
        return vec;
    }

    public Vec3 getRawPosition() {
        if (this.mob.isInWaterOrBubble()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)this.radius, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)this.radius, (int)7) : super.getPosition();
    }
}

