/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.magic;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.entity.ai.MageRangedAttackGoal;
import com.majorbonghits.moderncompanions.item.DaggerItem;
import com.majorbonghits.moderncompanions.item.QuarterstaffItem;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public abstract class AbstractMageCompanion
extends AbstractHumanCompanionEntity
implements RangedAttackMob {
    protected int heavyCooldown;

    protected AbstractMageCompanion(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        MageRangedAttackGoal<AbstractMageCompanion> castingGoal = new MageRangedAttackGoal<AbstractMageCompanion>(this, 1.05, this.getLightIntervalTicks(), this.getPreferredRange());
        this.goalSelector.addGoal(2, castingGoal);
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.equipCasterWeapon();
            if (this.heavyCooldown > 0) {
                --this.heavyCooldown;
            }
            this.faceTargetSmoothly();
        }
        super.tick();
    }

    private void faceTargetSmoothly() {
        double dz;
        LivingEntity target = this.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        double dx = target.getX() - this.getX();
        double dist2 = dx * dx + (dz = target.getZ() - this.getZ()) * dz;
        if (dist2 < 1.0E-6) {
            return;
        }
        float desiredYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        if (!Float.isFinite(desiredYaw)) {
            return;
        }
        desiredYaw = Mth.wrapDegrees((float)desiredYaw);
        float currentYaw = Float.isFinite(this.getYRot()) ? this.getYRot() : 0.0f;
        float newYaw = Mth.approachDegrees((float)currentYaw, (float)desiredYaw, (float)10.0f);
        if (!Float.isFinite(newYaw)) {
            return;
        }
        this.setYRot(newYaw);
        this.setYHeadRot(newYaw);
        this.yBodyRot = newYaw;
    }

    public abstract boolean tryHeavyAttack(LivingEntity var1, float var2);

    public abstract int getLightIntervalTicks();

    public float getPreferredRange() {
        return 18.0f;
    }

    public int getHeavyRecoveryTicks() {
        return this.getLightIntervalTicks();
    }

    protected float magicDamage(float base) {
        float scale = 1.0f + Math.max(0.0f, (float)(this.getIntelligence() - 4) * 0.08f);
        return base * scale;
    }

    protected void swingCast() {
        this.swing(InteractionHand.MAIN_HAND, true);
    }

    protected boolean isOwnerInDanger(LivingEntity target, float safeRadius) {
        if (!this.isTame()) {
            return false;
        }
        LivingEntity livingEntity = this.getOwner();
        if (!(livingEntity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity owner = livingEntity;
        return owner.distanceToSqr((Entity)target) <= (double)(safeRadius * safeRadius);
    }

    private void equipCasterWeapon() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!hand.isEmpty() && !this.isPreferredWeapon(hand)) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            hand = ItemStack.EMPTY;
        }
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!this.isPreferredWeapon(stack) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
    }

    private boolean isPreferredWeapon(ItemStack stack) {
        return stack.getItem() instanceof QuarterstaffItem || stack.getItem() instanceof DaggerItem || stack.is(Items.STICK) || stack.is(Items.BLAZE_ROD);
    }
}

