/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.projectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class NonIgnitingSmallFireball
extends SmallFireball {
    public NonIgnitingSmallFireball(EntityType<? extends NonIgnitingSmallFireball> type, Level level) {
        super(type, level);
    }

    public NonIgnitingSmallFireball(Level level, LivingEntity owner, Vec3 power) {
        super(level, owner, power);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.explodeEffect();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity hit = result.getEntity();
        Level lvl = this.level();
        if (lvl instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)lvl;
            Entity owner = this.getOwner();
            DamageSource source = this.damageSources().fireball((Fireball)this, owner);
            hit.hurt(source, 10.0f);
        }
        if (!lvl.isClientSide) {
            this.explodeEffect();
        }
    }

    private void explodeEffect() {
        this.level().explode(null, this.getX(), this.getY(), this.getZ(), 1.0f, false, Level.ExplosionInteraction.NONE);
        this.discard();
    }
}

