/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity.projectile;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SoftWitherSkull
extends WitherSkull {
    public SoftWitherSkull(EntityType<? extends SoftWitherSkull> type, Level level) {
        super(type, level);
    }

    public SoftWitherSkull(Level level, LivingEntity owner, Vec3 power) {
        super(level, owner, power);
        this.setDangerous(false);
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, false, Level.ExplosionInteraction.NONE);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                List victims = server.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.5), LivingEntity::isAlive);
                for (LivingEntity victim : victims) {
                    LivingEntity ownerLiving;
                    Entity owner = this.getOwner();
                    if (owner instanceof LivingEntity && victim.isAlliedTo((Entity)(ownerLiving = (LivingEntity)owner))) continue;
                    DamageSource src = this.damageSources().witherSkull((WitherSkull)this, owner);
                    victim.hurt(src, 5.0f);
                }
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity hit = result.getEntity();
        if (this.level() instanceof ServerLevel) {
            Entity owner = this.getOwner();
            if (owner != null && hit.isAlliedTo(owner)) {
                return;
            }
            DamageSource src = this.damageSources().witherSkull((WitherSkull)this, owner);
            hit.hurt(src, 5.0f);
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.discard();
        }
    }
}

