/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;

public abstract class BasicWeaponSweeplessItem
extends TieredItem {
    private static final boolean BETTER_COMBAT_LOADED = ModList.get().isLoaded("bettercombat");

    public BasicWeaponSweeplessItem(Tier material, TagKey<Block> effectiveBlocks, float attackDamage, float attackSpeed, double extraReach, Item.Properties properties) {
        super(material, properties.component(DataComponents.TOOL, (Object)BasicWeaponSweeplessItem.createToolProperties(material, effectiveBlocks)).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BasicWeaponSweeplessItem.createAttributes(material, attackDamage, attackSpeed, extraReach)));
    }

    private static Tool createToolProperties(Tier material, TagKey<Block> effectiveBlocks) {
        ArrayList<Tool.Rule> rules = new ArrayList<Tool.Rule>();
        if (effectiveBlocks.equals((Object)BlockTags.SWORD_EFFICIENT)) {
            rules.add(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f));
        }
        return new Tool(rules, 1.0f, 1);
    }

    private static ItemAttributeModifiers createAttributes(Tier tier, float attackDamage, float attackSpeed, double reach) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        if (!BETTER_COMBAT_LOADED) {
            builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Constants.REACH_MODIFIER_ID, reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        return builder.build();
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }
}

