/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.core.ModItems;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.StoredCompanionItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CompanionMoverItem
extends Item {
    public CompanionMoverItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(128));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!(entity instanceof AbstractHumanCompanionEntity)) {
            return InteractionResult.PASS;
        }
        AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
        Level level = entity.level();
        Vec3 position = entity.position();
        if (!companion.isTame() || !player.getUUID().equals(companion.getOwnerUUID())) {
            CompanionMoverItem.spawnParticles(level, position, true);
            CompanionMoverItem.playSound(level, position, SoundEvents.VILLAGER_NO);
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.companion_mover.not_owner"), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (level.isClientSide()) {
            CompanionMoverItem.spawnParticles(level, position, false);
            CompanionMoverItem.playSound(level, position, SoundEvents.ITEM_PICKUP);
            return InteractionResult.SUCCESS;
        }
        ItemStack stored = StoredCompanionItem.createFromCompanion(companion, (Item)ModItems.STORED_COMPANION.get());
        boolean added = player.getInventory().add(stored);
        if (!added) {
            ItemEntity drop = new ItemEntity(level, position.x(), position.y() + 0.2, position.z(), stored);
            drop.setUnlimitedLifetime();
            level.addFreshEntity((Entity)drop);
        }
        companion.discard();
        CompanionMoverItem.spawnParticles(level, position, false);
        CompanionMoverItem.playSound(level, position, SoundEvents.ITEM_PICKUP);
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        stack.hurtAndBreak(1, (LivingEntity)player, slot);
        return InteractionResult.CONSUME;
    }

    private static void spawnParticles(Level level, Vec3 position, boolean failedCapture) {
        for (int i = 0; i < 15; ++i) {
            double offsetX = level.random.nextDouble() * 0.6 - 0.3;
            double offsetY = level.random.nextDouble() * 0.6;
            double offsetZ = level.random.nextDouble() * 0.6 - 0.3;
            double velocityX = level.random.nextGaussian() * 0.02;
            double velocityY = level.random.nextGaussian() * (failedCapture ? 0.06 : 0.12);
            double velocityZ = level.random.nextGaussian() * 0.02;
            if (level.isClientSide()) {
                level.addParticle((ParticleOptions)(failedCapture ? ParticleTypes.SMOKE : ParticleTypes.POOF), position.x() + offsetX, position.y() + offsetY, position.z() + offsetZ, velocityX, velocityY, velocityZ);
                continue;
            }
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)(failedCapture ? ParticleTypes.SMOKE : ParticleTypes.POOF), position.x() + offsetX, position.y() + offsetY, position.z() + offsetZ, 1, velocityX, velocityY, velocityZ, 0.0);
        }
    }

    private static void playSound(Level level, Vec3 position, SoundEvent sound) {
        level.playSound(null, position.x(), position.y(), position.z(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

