/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.core.ModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="modern_companions")
public final class ResurrectionScrollEvents {
    private ResurrectionScrollEvents() {
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity item = (ItemEntity)entity;
        ItemStack stack = item.getItem();
        if (!stack.is((Item)ModItems.RESURRECTION_SCROLL.get())) {
            return;
        }
        stack.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
        item.setInvulnerable(true);
        item.setNoGravity(true);
        item.setDeltaMovement(Vec3.ZERO);
        item.setUnlimitedLifetime();
        item.clearFire();
        double floor = (double)event.getLevel().getMinBuildHeight() + 0.25;
        if (item.getY() < floor) {
            item.setPos(item.getX(), floor, item.getZ());
        }
    }
}

