/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ResurrectionScrollItem
extends Item {
    private static final String ACTIVATED_TAG = "Activated";
    private static final String COMPANION_NAME_TAG = "CompanionName";
    private static final String ENTITY_TYPE_TAG = "id";

    public ResurrectionScrollItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static ItemStack createFromCompanion(AbstractHumanCompanionEntity companion, Item scrollItem) {
        ItemStack stack = new ItemStack((ItemLike)scrollItem);
        ResurrectionScrollItem.storeCompanionData(stack, companion);
        ResurrectionScrollItem.setActivated(stack, false);
        return stack;
    }

    public static boolean isActivated(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return data.copyTag().getBoolean(ACTIVATED_TAG);
    }

    public static void setActivated(ItemStack stack, boolean activated) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putBoolean(ACTIVATED_TAG, activated));
        if (activated) {
            stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        } else {
            stack.remove(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        }
    }

    public static boolean hasCompanionData(ItemStack stack) {
        CustomData stored = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !stored.isEmpty() && stored.copyTag().contains(ENTITY_TYPE_TAG);
    }

    @Nullable
    private static ResourceLocation readEntityId(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return null;
        }
        return ResourceLocation.tryParse((String)data.copyTag().getString(ENTITY_TYPE_TAG));
    }

    private static void storeCompanionData(ItemStack stack, AbstractHumanCompanionEntity companion) {
        CompoundTag entityData = new CompoundTag();
        companion.saveWithoutId(entityData);
        ResourceLocation typeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)companion.getType());
        entityData.putString(ENTITY_TYPE_TAG, typeId.toString());
        entityData.putFloat("Health", companion.getMaxHealth());
        entityData.remove("DeathTime");
        entityData.remove("HurtTime");
        entityData.remove("HurtByTimestamp");
        entityData.remove("Pos");
        entityData.remove("Motion");
        entityData.remove("Rotation");
        CustomData.set((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)stack, (CompoundTag)entityData);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(COMPANION_NAME_TAG, companion.getName().getString()));
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.modern_companions.resurrection_scroll.named", (Object[])new Object[]{companion.getName()}));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (this.tryActivate(stack, context.getPlayer())) {
            return InteractionResult.CONSUME;
        }
        if (!this.validateReady(stack, (ServerLevel)level, context.getPlayer())) {
            return InteractionResult.FAIL;
        }
        Vec3 spawnPos = this.resolveSpawnPosition(context.getClickLocation(), context.getClickedFace(), (ServerLevel)level);
        Entity revived = this.revive((ServerLevel)level, stack, spawnPos, context.getPlayer());
        if (revived != null) {
            stack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)spawnPos));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.tryActivate(stack, player)) {
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!this.validateReady(stack, serverLevel, player)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockHitResult hit = ResurrectionScrollItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = hit.getBlockPos();
        if (!(level.getBlockState(pos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 spawnPos = this.resolveSpawnPosition(hit.getLocation(), hit.getDirection(), serverLevel);
        Entity revived = this.revive(serverLevel, stack, spawnPos, player);
        if (revived != null) {
            stack.consume(1, (LivingEntity)player);
            player.level().gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)revived.position()));
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private boolean validateReady(ItemStack stack, ServerLevel level, @Nullable Player player) {
        if (!ResurrectionScrollItem.isActivated(stack)) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.inactive"), true);
            }
            return false;
        }
        if (!ResurrectionScrollItem.hasCompanionData(stack)) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.empty"), true);
            }
            return false;
        }
        return true;
    }

    private Vec3 resolveSpawnPosition(Vec3 hitLocation, Direction face, ServerLevel level) {
        Vec3 nudge = Vec3.atLowerCornerOf((Vec3i)face.getNormal()).scale(0.02);
        Vec3 pos = hitLocation.add(nudge);
        double x = pos.x();
        double y = pos.y();
        double z = pos.z();
        double minY = (double)level.getMinBuildHeight() + 0.05;
        double maxY = (double)level.getMaxBuildHeight() - 0.1;
        y = Math.min(Math.max(y, minY), maxY);
        return new Vec3(x, y, z);
    }

    private boolean tryActivate(ItemStack stack, @Nullable Player player) {
        if (player == null || ResurrectionScrollItem.isActivated(stack)) {
            return false;
        }
        ItemStack offhand = player.getOffhandItem();
        if (!offhand.is(Items.NETHER_STAR)) {
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.needs_nether_star"), true);
            return false;
        }
        offhand.shrink(1);
        ResurrectionScrollItem.setActivated(stack, true);
        player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.activated"), true);
        return true;
    }

    @Nullable
    private Entity revive(ServerLevel level, ItemStack stack, Vec3 pos, @Nullable Player player) {
        ResourceLocation typeId = ResurrectionScrollItem.readEntityId(stack);
        if (typeId == null) {
            return null;
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
        Entity entity = type.create((Level)level);
        if (!(entity instanceof AbstractHumanCompanionEntity)) {
            return null;
        }
        AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
        CustomData storedData = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = storedData.copyTag();
        companion.load(tag);
        double safeY = Math.max(pos.y(), (double)level.getMinBuildHeight() + 0.01);
        companion.moveTo(pos.x(), safeY, pos.z(), level.random.nextFloat() * 360.0f, 0.0f);
        companion.setHealth(companion.getMaxHealth());
        companion.setDeltaMovement(Vec3.ZERO);
        companion.setOnGround(true);
        level.addFreshEntity((Entity)companion);
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            BlockPos spawnedAt = BlockPos.containing((Position)companion.position());
            player.displayClientMessage((Component)Component.translatable((String)"message.modern_companions.resurrection_scroll.spawned", (Object[])new Object[]{spawnedAt.getX(), spawnedAt.getY(), spawnedAt.getZ()}), true);
        }
        return companion;
    }

    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.ITEM_NAME)) {
            return (Component)stack.get(DataComponents.ITEM_NAME);
        }
        return Component.translatable((String)"item.modern_companions.resurrection_scroll");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String name = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString(COMPANION_NAME_TAG);
        if (!name.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.bound", (Object[])new Object[]{name}));
        }
        if (ResurrectionScrollItem.isActivated(stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.active"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.inactive"));
        }
        if (!ResurrectionScrollItem.hasCompanionData(stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.resurrection_scroll.empty"));
        }
    }
}

