/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StoredCompanionItem
extends Item {
    private static final String COMPANION_NAME_TAG = "CompanionName";
    private static final String ENTITY_TYPE_TAG = "id";

    public StoredCompanionItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static ItemStack createFromCompanion(AbstractHumanCompanionEntity companion, Item storedItem) {
        ItemStack stack = new ItemStack((ItemLike)storedItem);
        StoredCompanionItem.storeCompanionData(stack, companion);
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return stack;
    }

    public static boolean hasCompanionData(ItemStack stack) {
        CustomData stored = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !stored.isEmpty() && stored.copyTag().contains(ENTITY_TYPE_TAG);
    }

    @Nullable
    private static ResourceLocation readEntityId(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return null;
        }
        return ResourceLocation.tryParse((String)data.copyTag().getString(ENTITY_TYPE_TAG));
    }

    private static void storeCompanionData(ItemStack stack, AbstractHumanCompanionEntity companion) {
        CompoundTag entityData = new CompoundTag();
        companion.saveWithoutId(entityData);
        ResourceLocation typeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)companion.getType());
        entityData.putString(ENTITY_TYPE_TAG, typeId.toString());
        entityData.putFloat("Health", companion.getMaxHealth());
        entityData.remove("DeathTime");
        entityData.remove("HurtTime");
        entityData.remove("HurtByTimestamp");
        entityData.remove("Pos");
        entityData.remove("Motion");
        entityData.remove("Rotation");
        CustomData.set((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)stack, (CompoundTag)entityData);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(COMPANION_NAME_TAG, companion.getName().getString()));
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.modern_companions.stored_companion.named", (Object[])new Object[]{companion.getName()}));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!StoredCompanionItem.hasCompanionData(stack)) {
            this.notifyMissingData(context.getPlayer());
            return InteractionResult.FAIL;
        }
        Vec3 spawnPos = context.getClickLocation().add(Vec3.atLowerCornerOf((Vec3i)context.getClickedFace().getNormal()).scale(0.02));
        Entity placed = this.placeCompanion(serverLevel, stack, spawnPos, context.getPlayer());
        if (placed != null) {
            stack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)placed.position()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!StoredCompanionItem.hasCompanionData(stack)) {
            this.notifyMissingData(player);
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockHitResult hit = StoredCompanionItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 spawnPos = hit.getLocation().add(Vec3.atLowerCornerOf((Vec3i)hit.getDirection().getNormal()).scale(0.02));
        Entity placed = this.placeCompanion(serverLevel, stack, spawnPos, player);
        if (placed != null) {
            stack.consume(1, (LivingEntity)player);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)placed.position()));
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @Nullable
    private Entity placeCompanion(ServerLevel level, ItemStack stack, Vec3 pos, @Nullable Player player) {
        ResourceLocation typeId = StoredCompanionItem.readEntityId(stack);
        if (typeId == null) {
            return null;
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
        Entity entity = type.create((Level)level);
        if (!(entity instanceof AbstractHumanCompanionEntity)) {
            return null;
        }
        AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
        CustomData storedData = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = storedData.copyTag();
        companion.load(tag);
        double safeY = Math.max(pos.y(), (double)level.getMinBuildHeight() + 0.01);
        companion.moveTo(pos.x(), safeY, pos.z(), level.random.nextFloat() * 360.0f, 0.0f);
        companion.setHealth(companion.getMaxHealth());
        companion.setDeltaMovement(Vec3.ZERO);
        companion.setOnGround(true);
        level.addFreshEntity((Entity)companion);
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return companion;
    }

    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.ITEM_NAME)) {
            return (Component)stack.get(DataComponents.ITEM_NAME);
        }
        return Component.translatable((String)"item.modern_companions.stored_companion");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String name = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString(COMPANION_NAME_TAG);
        if (!name.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.stored_companion.bound", (Object[])new Object[]{name}));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.modern_companions.stored_companion.empty"));
        }
    }

    private void notifyMissingData(@Nullable Player player) {
        if (player != null) {
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.modern_companions.stored_companion.empty"), true);
        }
    }
}

