/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.item;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.entity.Beastmaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SummoningWandItem
extends Item {
    private static final int SEARCH_RADIUS = 256;

    public SummoningWandItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(256).rarity(Rarity.UNCOMMON).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 targetPos = player.position();
        List<AbstractHumanCompanionEntity> recalled = this.recallCompanions(server, player, targetPos);
        if (!recalled.isEmpty()) {
            server.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
            player.getCooldowns().addCooldown((Item)this, 10);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)server.isClientSide());
    }

    private List<AbstractHumanCompanionEntity> recallCompanions(ServerLevel server, Player player, Vec3 target) {
        ArrayList<AbstractHumanCompanionEntity> moved = new ArrayList<AbstractHumanCompanionEntity>();
        AABB searchBox = new AABB(BlockPos.containing((Position)target)).inflate(256.0);
        for (AbstractHumanCompanionEntity companion : server.getEntitiesOfClass(AbstractHumanCompanionEntity.class, searchBox, c -> c.isAlive() && c.isTame() && player.getUUID().equals(c.getOwnerUUID()))) {
            Optional<Vec3> safe = this.findSafeSpot(server, target, (LivingEntity)companion);
            safe.ifPresent(pos -> {
                companion.teleportTo(pos.x(), pos.y(), pos.z());
                companion.getNavigation().stop();
                moved.add(companion);
                if (companion instanceof Beastmaster) {
                    Beastmaster beastmaster = (Beastmaster)companion;
                    this.teleportPetIfPresent(server, beastmaster, (Vec3)pos);
                }
            });
        }
        return moved;
    }

    private void teleportPetIfPresent(ServerLevel server, Beastmaster beastmaster, Vec3 ownerPos) {
        LivingEntity pet = beastmaster.getPetEntity(server);
        if (pet != null && pet.isAlive()) {
            this.findSafeSpot(server, ownerPos, pet).ifPresent(pos -> {
                pet.teleportTo(pos.x(), pos.y(), pos.z());
                if (pet instanceof PathfinderMob) {
                    PathfinderMob mob = (PathfinderMob)pet;
                    mob.getNavigation().stop();
                }
            });
        }
    }

    private Optional<Vec3> findSafeSpot(ServerLevel level, Vec3 center, LivingEntity entity) {
        BlockPos base = BlockPos.containing((Position)center);
        for (int i = 0; i < 12; ++i) {
            int dz;
            int dx = level.random.nextInt(5) - 2;
            BlockPos candidate = base.offset(dx, 0, dz = level.random.nextInt(5) - 2);
            if (!this.isTeleportFriendly(level, candidate, entity)) continue;
            return Optional.of(Vec3.atCenterOf((Vec3i)candidate));
        }
        BlockPos centerPos = BlockPos.containing((Position)center);
        if (this.isTeleportFriendly(level, centerPos, entity)) {
            return Optional.of(Vec3.atCenterOf((Vec3i)centerPos));
        }
        return Optional.empty();
    }

    private boolean isTeleportFriendly(ServerLevel level, BlockPos pos, LivingEntity entity) {
        return level.isEmptyBlock(pos) && level.isEmptyBlock(pos.above()) && level.noCollision((Entity)entity, entity.getBoundingBox().move((double)pos.getX() - entity.getX(), (double)pos.getY() - entity.getY(), (double)pos.getZ() - entity.getZ()));
    }
}

