/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.menu;

import com.majorbonghits.moderncompanions.core.ModMenuTypes;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CompanionMenu
extends AbstractContainerMenu {
    private static final int COMPANION_ROWS = 6;
    private final Container container;
    private final int companionId;
    private final AbstractHumanCompanionEntity companion;

    public CompanionMenu(int id, Inventory playerInv, int companionId) {
        this(id, playerInv, CompanionMenu.resolveContainer(playerInv, companionId), companionId, CompanionMenu.resolveEntity(playerInv, companionId));
    }

    public CompanionMenu(int id, Inventory playerInv, AbstractHumanCompanionEntity companion) {
        this(id, playerInv, (Container)companion.getInventory(), companion.getId(), companion);
    }

    private CompanionMenu(int id, Inventory playerInv, Container container, int companionId, AbstractHumanCompanionEntity companion) {
        super((MenuType)ModMenuTypes.COMPANION_MENU.get(), id);
        int col;
        this.container = container;
        this.companionId = companionId;
        this.companion = companion;
        CompanionMenu.checkContainerSize((Container)container, (int)54);
        container.startOpen(playerInv.player);
        for (int row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot(container, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        int offset = 36;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)playerInv, col2 + row * 9 + 9, 8 + col2 * 18, 103 + row * 18 + offset));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 161 + offset));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < 54 ? !this.moveItemStackTo(stack, 54, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public int getCompanionId() {
        return this.companionId;
    }

    public AbstractHumanCompanionEntity getCompanion() {
        return this.companion;
    }

    private static Container resolveContainer(Inventory inv, int id) {
        AbstractHumanCompanionEntity c = CompanionMenu.resolveEntity(inv, id);
        return c != null ? c.getInventory() : new SimpleContainer(54);
    }

    private static AbstractHumanCompanionEntity resolveEntity(Inventory inv, int id) {
        Entity entity = inv.player.level().getEntity(id);
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity c = (AbstractHumanCompanionEntity)entity;
            return c;
        }
        return null;
    }
}

