/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.network;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.network.CompanionActionPayload;
import com.majorbonghits.moderncompanions.network.SetPatrolRadiusPayload;
import com.majorbonghits.moderncompanions.network.ToggleFlagPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="modern_companions")
public final class ModNetwork {
    private ModNetwork() {
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        event.registrar("modern_companions").playToServer(ToggleFlagPayload.TYPE, ToggleFlagPayload.CODEC, ModNetwork::handleToggleFlag).playToServer(CompanionActionPayload.TYPE, CompanionActionPayload.CODEC, ModNetwork::handleAction).playToServer(SetPatrolRadiusPayload.TYPE, SetPatrolRadiusPayload.CODEC, ModNetwork::handlePatrolRadius);
    }

    private static void handleToggleFlag(ToggleFlagPayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractHumanCompanionEntity companion;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            Entity entity = serverPlayer.level().getEntity(payload.entityId());
            if (entity instanceof AbstractHumanCompanionEntity && (companion = (AbstractHumanCompanionEntity)entity).isOwnedBy((LivingEntity)serverPlayer)) {
                companion.applyFlag(payload.flag(), payload.value());
                switch (payload.flag()) {
                    case "alert": {
                        companion.setAlert(payload.value());
                        break;
                    }
                    case "hunt": {
                        companion.setHunting(payload.value());
                        break;
                    }
                    case "sprint": {
                        companion.setSprintEnabled(payload.value());
                        break;
                    }
                    case "patrol": {
                        companion.setPatrolPos(companion.blockPosition());
                        companion.setPatrolling(payload.value());
                        break;
                    }
                    case "guard": {
                        companion.setGuarding(payload.value());
                        companion.setPatrolPos(companion.blockPosition());
                        break;
                    }
                    case "follow": {
                        companion.setFollowing(payload.value());
                        break;
                    }
                    case "pickup": {
                        companion.setPickupEnabled(payload.value());
                        break;
                    }
                }
            }
        });
    }

    private static void handleAction(CompanionActionPayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractHumanCompanionEntity companion;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            Entity entity = serverPlayer.level().getEntity(payload.entityId());
            if (entity instanceof AbstractHumanCompanionEntity && (companion = (AbstractHumanCompanionEntity)entity).isOwnedBy((LivingEntity)serverPlayer)) {
                switch (payload.action()) {
                    case "cycle_orders": {
                        companion.cycleOrders();
                        break;
                    }
                    case "clear_target": {
                        companion.setTarget(null);
                        break;
                    }
                    case "release": {
                        companion.release();
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)(companion.getDisplayName().getString().split(" ")[0] + " is no longer your companion.")));
                        break;
                    }
                }
            }
        });
    }

    private static void handlePatrolRadius(SetPatrolRadiusPayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractHumanCompanionEntity companion;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            Entity entity = serverPlayer.level().getEntity(payload.entityId());
            if (entity instanceof AbstractHumanCompanionEntity && (companion = (AbstractHumanCompanionEntity)entity).isOwnedBy((LivingEntity)serverPlayer)) {
                companion.setPatrolRadius(payload.radius());
            }
        });
    }
}

