/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.registry;

import com.majorbonghits.moderncompanions.core.ModEnchantments;
import com.majorbonghits.moderncompanions.registry.ModItems;
import com.majorbonghits.moderncompanions.struct.WeaponType;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"modern_companions");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN = TABS.register("modern_companions", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.modern_companions")).icon(() -> new ItemStack((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.KNIGHT_SPAWN_EGG.get())).displayItems((params, output) -> {
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.KNIGHT_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.ARCHER_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.ARBALIST_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.AXEGUARD_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.VANGUARD_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.BERSERKER_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.BEASTMASTER_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.CLERIC_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.ALCHEMIST_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.SCOUT_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.STORMCALLER_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.FIRE_MAGE_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.LIGHTNING_MAGE_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.NECROMANCER_SPAWN_EGG.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.RESURRECTION_SCROLL.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.COMPANION_MOVER.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.STORED_COMPANION.get());
        output.accept((ItemLike)com.majorbonghits.moderncompanions.core.ModItems.SUMMONING_WAND.get());
        ModCreativeTabs.addEnchantBooks(params, output, ModEnchantments.EMPOWER);
        ModCreativeTabs.addEnchantBooks(params, output, ModEnchantments.NIMBILITY);
        ModCreativeTabs.addEnchantBooks(params, output, ModEnchantments.ENLIGHTENMENT);
        ModCreativeTabs.addEnchantBooks(params, output, ModEnchantments.VITALITY);
        for (WeaponType type : WeaponType.values()) {
            ModItems.getItemsByType(type).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        }
    }).build());

    private ModCreativeTabs() {
    }

    public static void register(IEventBus bus) {
        TABS.register(bus);
    }

    private static void addEnchantBooks(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, ResourceKey<Enchantment> enchantKey) {
        Optional lookupOpt = params.holders().lookup(Registries.ENCHANTMENT);
        lookupOpt.ifPresent(lookup -> lookup.get(enchantKey).ifPresent(holder -> ModCreativeTabs.addBookLevels(output, (Holder<Enchantment>)holder)));
    }

    private static void addBookLevels(CreativeModeTab.Output output, Holder<Enchantment> holder) {
        for (int level = 1; level <= 3; ++level) {
            ItemStack stack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(holder, level));
            ModCreativeTabs.applyCustomModelData((ResourceKey<Enchantment>)((ResourceKey)holder.unwrapKey().orElse(null)), level, stack);
            output.accept(stack);
        }
    }

    private static void applyCustomModelData(ResourceKey<Enchantment> key, int level, ItemStack stack) {
        int base;
        if (key == null) {
            return;
        }
        if (key.equals(ModEnchantments.EMPOWER)) {
            base = 410000;
        } else if (key.equals(ModEnchantments.NIMBILITY)) {
            base = 410010;
        } else if (key.equals(ModEnchantments.ENLIGHTENMENT)) {
            base = 410020;
        } else if (key.equals(ModEnchantments.VITALITY)) {
            base = 410030;
        } else {
            return;
        }
        int cmd = base + level;
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(cmd));
    }
}

