/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.registry;

import com.majorbonghits.moderncompanions.struct.WeaponType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModItems {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"modern_companions");
    private static final Map<WeaponType, List<Supplier<Item>>> ITEMS_BY_TYPE = new EnumMap<WeaponType, List<Supplier<Item>>>(WeaponType.class);
    private static final Tier BRONZE_TIER = new Tier(){

        public int getUses() {
            return 350;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 2.5f;
        }

        public int getEnchantmentValue() {
            return 13;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.NEEDS_IRON_TOOL;
        }
    };
    private static final List<MaterialEntry> MATERIALS = new ArrayList<MaterialEntry>(List.of(new MaterialEntry((Tier)Tiers.WOOD, "wooden"), new MaterialEntry((Tier)Tiers.STONE, "stone"), new MaterialEntry((Tier)Tiers.IRON, "iron"), new MaterialEntry((Tier)Tiers.GOLD, "golden"), new MaterialEntry((Tier)Tiers.DIAMOND, "diamond"), new MaterialEntry((Tier)Tiers.NETHERITE, "netherite", props -> props.fireResistant())));

    private ModItems() {
    }

    private static void registerAllWeaponsForMaterial(MaterialEntry material) {
        for (WeaponType type : WeaponType.values()) {
            String itemId = material.prefix() + "_" + type.getId();
            Item.Properties properties = (Item.Properties)material.settingsModifier().apply(new Item.Properties());
            float damageModifier = WeaponType.getDamageModifier(type, material.tier());
            float speedModifier = WeaponType.getSpeedModifier(type, material.tier());
            float reachModifier = WeaponType.getReachModifier(type, material.tier());
            DeferredItem registered = ITEMS.register(itemId, () -> type.create(material.tier(), damageModifier, speedModifier, reachModifier, properties));
            ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(registered);
        }
    }

    public static List<Item> getItemsByType(WeaponType type) {
        return ITEMS_BY_TYPE.getOrDefault((Object)type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public static void register(IEventBus modBus) {
        ITEMS.register(modBus);
    }

    static {
        if (ModList.get().isLoaded("bronze")) {
            MATERIALS.add(new MaterialEntry(BRONZE_TIER, "bronze"));
        }
        for (MaterialEntry material : MATERIALS) {
            ModItems.registerAllWeaponsForMaterial(material);
        }
    }

    private record MaterialEntry(Tier tier, String prefix, UnaryOperator<Item.Properties> settingsModifier) {
        MaterialEntry(Tier tier, String prefix) {
            this(tier, prefix, UnaryOperator.identity());
        }
    }
}

