/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.struct;

import com.majorbonghits.moderncompanions.item.ClubItem;
import com.majorbonghits.moderncompanions.item.DaggerItem;
import com.majorbonghits.moderncompanions.item.GlaiveItem;
import com.majorbonghits.moderncompanions.item.HammerItem;
import com.majorbonghits.moderncompanions.item.QuarterstaffItem;
import com.majorbonghits.moderncompanions.item.SpearItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public enum WeaponType {
    DAGGER("dagger", 1.0f, -1.6f, 0.0, DaggerItem::new),
    HAMMER("hammer", 7.0f, -3.4f, 0.0, HammerItem::new),
    CLUB("club", 5.0f, -3.0f, 0.0, ClubItem::new),
    SPEAR("spear", 2.0f, -2.8f, 2.0, SpearItem::new),
    QUARTERSTAFF("quarterstaff", 1.0f, -2.3f, 1.25, QuarterstaffItem::new),
    GLAIVE("glaive", 5.0f, -3.2f, 1.25, GlaiveItem::new);

    private final String id;
    private final float baseDamage;
    private final float baseSpeed;
    private final double baseReach;
    private final WeaponFactory factory;

    private WeaponType(String id, float baseDamage, float baseSpeed, double baseReach, WeaponFactory factory) {
        this.id = id;
        this.baseDamage = baseDamage;
        this.baseSpeed = baseSpeed;
        this.baseReach = baseReach;
        this.factory = factory;
    }

    public String getId() {
        return this.id;
    }

    public Item create(Tier material, float damageModifier, float speedModifier, float reachModifier, Item.Properties properties) {
        return this.factory.create(material, this.baseDamage + damageModifier, this.baseSpeed + speedModifier, this.baseReach + (double)reachModifier, properties);
    }

    public static float getDamageModifier(WeaponType type, Tier material) {
        if (type == DAGGER && material == Tiers.GOLD) {
            return -1.0f;
        }
        if (type == HAMMER) {
            if (material == Tiers.WOOD) {
                return -6.0f;
            }
            if (material == Tiers.STONE) {
                return -3.0f;
            }
            if (material == Tiers.GOLD) {
                return -6.0f;
            }
            return -1.0f;
        }
        return 0.0f;
    }

    public static float getSpeedModifier(WeaponType type, Tier material) {
        if (type == DAGGER && material == Tiers.GOLD) {
            return 1.0f;
        }
        if (type == HAMMER) {
            if (material == Tiers.WOOD) {
                return 0.4f;
            }
            if (material == Tiers.STONE) {
                return 0.2f;
            }
            if (material == Tiers.GOLD) {
                return 0.6f;
            }
            if (material == Tiers.NETHERITE) {
                return 0.2f;
            }
            return 0.1f;
        }
        return 0.0f;
    }

    public static float getReachModifier(WeaponType type, Tier material) {
        return 0.0f;
    }

    @FunctionalInterface
    public static interface WeaponFactory {
        public Item create(Tier var1, float var2, float var3, double var4, Item.Properties var6);
    }
}

