/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.client;

import com.troldg.wallpapertrl.client.gui.CustomTitleScreen;
import com.troldg.wallpapertrl.client.gui.IntroScreen;
import com.troldg.wallpapertrl.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    private static boolean introShown = false;

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening event) {
        if (event.getNewScreen() instanceof TitleScreen) {
            if (!introShown && ClientEventHandler.shouldShowIntro()) {
                event.setNewScreen((Screen)new IntroScreen());
            } else {
                event.setNewScreen((Screen)new CustomTitleScreen());
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        IntroScreen introScreen;
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91080_ instanceof IntroScreen && (introScreen = (IntroScreen)Minecraft.m_91087_().f_91080_).isFinished()) {
            introShown = true;
            Minecraft.m_91087_().m_91152_((Screen)new CustomTitleScreen());
        }
    }

    private static boolean shouldShowIntro() {
        String introPath = ModConfig.getIntroPath();
        return introPath != null && !introPath.isEmpty();
    }

    public static void resetToCustomMenu() {
        Minecraft.m_91087_().m_91152_((Screen)new CustomTitleScreen());
    }
}

