/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ResourceLocation> LOADED_TEXTURES = new HashMap<String, ResourceLocation>();
    private static int textureCounter = 0;

    public static ResourceLocation loadTextureFromFile(File file) {
        ResourceLocation resourceLocation;
        if (file == null || !file.exists()) {
            LOGGER.warn("Texture file not found: {}", (Object)file);
            return null;
        }
        String key = file.getAbsolutePath();
        if (LOADED_TEXTURES.containsKey(key)) {
            return LOADED_TEXTURES.get(key);
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
            DynamicTexture dynamicTexture = new DynamicTexture(image);
            ResourceLocation textureId = ResourceLocation.fromNamespaceAndPath((String)"menumod", (String)("dynamic_" + textureCounter++));
            Minecraft.m_91087_().m_91097_().m_118495_(textureId, (AbstractTexture)dynamicTexture);
            LOADED_TEXTURES.put(key, textureId);
            LOGGER.info("Successfully loaded texture: {}", (Object)file.getAbsolutePath());
            resourceLocation = textureId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load texture from file: {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error loading texture: {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
        }
        inputStream.close();
        return resourceLocation;
    }

    public static void clearTextures() {
        for (ResourceLocation textureId : LOADED_TEXTURES.values()) {
            Minecraft.m_91087_().m_91097_().m_118513_(textureId);
        }
        LOADED_TEXTURES.clear();
        textureCounter = 0;
    }

    public static boolean textureFileExists(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static long getTextureFileLastModified(File file) {
        if (TextureLoader.textureFileExists(file)) {
            return file.lastModified();
        }
        return -1L;
    }
}

