/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.client.gui;

import com.troldg.wallpapertrl.config.ModConfig;
import com.troldg.wallpapertrl.theme.ThemeManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ButtonConfigScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Screen parent;
    private Map<String, DraggableButton> draggableButtons = new HashMap<String, DraggableButton>();
    private Map<String, DraggableButton> originalButtons = new HashMap<String, DraggableButton>();
    private EditBox widthField;
    private EditBox heightField;
    private EditBox textureNormalField;
    private EditBox textureHoverField;
    private DraggableButton selectedButton = null;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private String originalWidth;
    private String originalHeight;
    private String originalTextureNormal;
    private String originalTextureHover;

    public ButtonConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"menumod.screen.button_settings"));
        this.parent = parent;
    }

    protected void m_7856_() {
        int y = 40;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.config.enable_button_customization").m_130946_(": " + (ModConfig.enableButtonCustomization() ? "ON" : "OFF")), button -> {
            boolean current = ModConfig.enableButtonCustomization();
            ModConfig.ENABLE_BUTTON_CUSTOMIZATION.set((Object)(!current ? 1 : 0));
            ModConfig.SPEC.save();
            button.m_93666_((Component)Component.m_237115_((String)"menumod.config.enable_button_customization").m_130946_(": " + (!current ? "ON" : "OFF")));
        }).m_252987_(this.f_96543_ / 2 - 150, y, 300, 20).m_253136_());
        this.widthField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, y += 30, 145, 20, (Component)Component.m_237113_((String)"Width"));
        this.widthField.m_94144_(String.valueOf(ModConfig.getButtonWidth()));
        this.m_142416_((GuiEventListener)this.widthField);
        this.heightField = new EditBox(this.f_96547_, this.f_96543_ / 2 + 5, y, 145, 20, (Component)Component.m_237113_((String)"Height"));
        this.heightField.m_94144_(String.valueOf(ModConfig.getButtonHeight()));
        this.m_142416_((GuiEventListener)this.heightField);
        this.textureNormalField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 175, y += 30, 350, 20, (Component)Component.m_237115_((String)"menumod.config.button_texture_norm"));
        this.textureNormalField.m_94144_(ModConfig.getButtonTextureNormal());
        this.textureNormalField.m_257771_((Component)Component.m_237113_((String)"default/buttons/button_norm.png"));
        this.textureNormalField.m_94199_(100);
        this.textureNormalField.m_94190_(true);
        this.textureNormalField.m_94151_(text -> this.textureNormalField.m_94196_(text.length()));
        this.m_142416_((GuiEventListener)this.textureNormalField);
        this.textureHoverField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 175, y += 25, 350, 20, (Component)Component.m_237115_((String)"menumod.config.button_texture_hover"));
        this.textureHoverField.m_94144_(ModConfig.getButtonTextureHover());
        this.textureHoverField.m_257771_((Component)Component.m_237113_((String)"default/buttons/button_hover.png"));
        this.textureHoverField.m_94199_(100);
        this.textureHoverField.m_94190_(true);
        this.textureHoverField.m_94151_(text -> this.textureHoverField.m_94196_(text.length()));
        this.m_142416_((GuiEventListener)this.textureHoverField);
        y += 35;
        this.createDraggableButtons();
        this.saveOriginalValues();
        int bottomY = this.f_96544_ - 80;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.reset"), button -> this.resetToDefaults()).m_252987_(this.f_96543_ / 2 - 150, bottomY, 145, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.cancel"), button -> this.cancelChanges()).m_252987_(this.f_96543_ / 2 + 5, bottomY, 145, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.save"), button -> this.saveConfig()).m_252987_(this.f_96543_ / 2 - 150, bottomY += 25, 145, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 5, bottomY, 145, 20).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.textureNormalField != null && this.textureNormalField.m_93696_()) {
            this.textureNormalField.m_94196_(this.textureNormalField.m_94155_().length());
        }
        if (this.textureHoverField != null && this.textureHoverField.m_93696_()) {
            this.textureHoverField.m_94196_(this.textureHoverField.m_94155_().length());
        }
    }

    private void saveOriginalValues() {
        this.originalWidth = this.widthField.m_94155_();
        this.originalHeight = this.heightField.m_94155_();
        this.originalTextureNormal = this.textureNormalField.m_94155_();
        this.originalTextureHover = this.textureHoverField.m_94155_();
        this.originalButtons.clear();
        for (Map.Entry<String, DraggableButton> entry : this.draggableButtons.entrySet()) {
            DraggableButton original = entry.getValue();
            this.originalButtons.put(entry.getKey(), new DraggableButton(original.text, original.x, original.y, original.width, original.height, original.color));
        }
    }

    private void cancelChanges() {
        this.widthField.m_94144_(this.originalWidth);
        this.heightField.m_94144_(this.originalHeight);
        this.textureNormalField.m_94144_(this.originalTextureNormal);
        this.textureHoverField.m_94144_(this.originalTextureHover);
        this.draggableButtons.clear();
        for (Map.Entry<String, DraggableButton> entry : this.originalButtons.entrySet()) {
            DraggableButton original = entry.getValue();
            this.draggableButtons.put(entry.getKey(), new DraggableButton(original.text, original.x, original.y, original.width, original.height, original.color));
        }
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"menumod.message.changes_canceled"), false);
        }
    }

    private void createDraggableButtons() {
        int centerX = this.f_96543_ / 2;
        int startY = 180;
        this.draggableButtons.put("singleplayer", new DraggableButton((Component)Component.m_237115_((String)"menumod.button.singleplayer"), centerX + ModConfig.getButtonSingleplayerX(), startY + ModConfig.getButtonSingleplayerY(), ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), -2147418368));
        this.draggableButtons.put("multiplayer", new DraggableButton((Component)Component.m_237115_((String)"menumod.button.multiplayer"), centerX + ModConfig.getButtonMultiplayerX(), startY + ModConfig.getButtonMultiplayerY(), ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), -2147483393));
        this.draggableButtons.put("options", new DraggableButton((Component)Component.m_237115_((String)"menumod.button.options"), centerX + ModConfig.getButtonOptionsX(), startY + ModConfig.getButtonOptionsY(), ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), -2130706688));
        this.draggableButtons.put("settings", new DraggableButton((Component)Component.m_237115_((String)"menumod.button.menu_settings"), centerX + ModConfig.getButtonSettingsX(), startY + ModConfig.getButtonSettingsY(), ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), -2130771713));
        this.draggableButtons.put("quit", new DraggableButton((Component)Component.m_237115_((String)"menumod.button.quit"), centerX + ModConfig.getButtonQuitX(), startY + ModConfig.getButtonQuitY(), ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), -2130771968));
    }

    private void resetToDefaults() {
        ModConfig.resetAllButtonPositions();
        this.widthField.m_94144_(String.valueOf(200));
        this.heightField.m_94144_(String.valueOf(20));
        this.textureNormalField.m_94144_("default/buttons/button_norm.png");
        this.textureHoverField.m_94144_("default/buttons/button_hover.png");
        this.createDraggableButtons();
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"menumod.message.reset_to_defaults"), false);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Map.Entry<String, DraggableButton> entry : this.draggableButtons.entrySet()) {
            DraggableButton draggableButton = entry.getValue();
            if (!(mouseX >= (double)draggableButton.x) || !(mouseX <= (double)(draggableButton.x + draggableButton.width)) || !(mouseY >= (double)draggableButton.y) || !(mouseY <= (double)(draggableButton.y + draggableButton.height))) continue;
            this.selectedButton = draggableButton;
            this.dragOffsetX = (int)(mouseX - (double)draggableButton.x);
            this.dragOffsetY = (int)(mouseY - (double)draggableButton.y);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selectedButton != null) {
            this.selectedButton.x = (int)mouseX - this.dragOffsetX;
            this.selectedButton.y = (int)mouseY - this.dragOffsetY;
            this.selectedButton.x = Math.max(0, Math.min(this.f_96543_ - this.selectedButton.width, this.selectedButton.x));
            this.selectedButton.y = Math.max(150, Math.min(this.f_96544_ - 60, this.selectedButton.y));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.selectedButton = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void saveConfig() {
        block4: {
            try {
                int width = Integer.parseInt(this.widthField.m_94155_());
                int height = Integer.parseInt(this.heightField.m_94155_());
                ModConfig.BUTTON_WIDTH.set((Object)Math.max(50, Math.min(1000, width)));
                ModConfig.BUTTON_HEIGHT.set((Object)Math.max(10, Math.min(100, height)));
                String normalPath = this.textureNormalField.m_94155_().trim();
                String hoverPath = this.textureHoverField.m_94155_().trim();
                ModConfig.BUTTON_TEXTURE_NORMAL.set((Object)normalPath);
                ModConfig.BUTTON_TEXTURE_HOVER.set((Object)hoverPath);
                int centerX = this.f_96543_ / 2;
                int startY = 180;
                for (Map.Entry<String, DraggableButton> entry : this.draggableButtons.entrySet()) {
                    DraggableButton draggableBtn = entry.getValue();
                    int relativeX = draggableBtn.x - centerX;
                    int relativeY = draggableBtn.y - startY;
                    ModConfig.setButtonPosition(entry.getKey(), relativeX, relativeY);
                }
                ModConfig.SPEC.save();
                ThemeManager.reloadAllTextures();
                LOGGER.info("Saved button texture paths - Normal: {}, Hover: {}", (Object)normalPath, (Object)hoverPath);
                if (this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"menumod.message.saved"), false);
                }
            }
            catch (NumberFormatException e) {
                if (this.f_96541_.f_91074_ == null) break block4;
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"menumod.message.error").m_130946_(": Invalid number format"), false);
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menumod.instruction.drag_buttons"), this.f_96543_ / 2, 160, 0x55FF55);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menumod.instruction.edit_paths"), this.f_96543_ / 2, 170, 0xAAAAAA);
        for (DraggableButton button : this.draggableButtons.values()) {
            button.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        int y = 150;
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menumod.config.button_positions"), this.f_96543_ / 2, y, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private class DraggableButton {
        public int x;
        public int y;
        public int width;
        public int height;
        public Component text;
        public int color;

        public DraggableButton(Component text, int x, int y, int width, int height, int color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.color = color;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, this.color);
            guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + 1, -1);
            guiGraphics.m_280509_(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -1);
            guiGraphics.m_280509_(this.x, this.y, this.x + 1, this.y + this.height, -1);
            guiGraphics.m_280509_(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -1);
            int textX = this.x + (this.width - ButtonConfigScreen.this.f_96547_.m_92852_((FormattedText)this.text)) / 2;
            int textY = this.y + (this.height - 8) / 2;
            guiGraphics.m_280614_(ButtonConfigScreen.this.f_96547_, this.text, textX, textY, 0xFFFFFF, false);
        }
    }
}

