/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.client.gui;

import com.troldg.wallpapertrl.client.gui.CustomButton;
import com.troldg.wallpapertrl.client.gui.ThemeConfigScreen;
import com.troldg.wallpapertrl.config.ModConfig;
import com.troldg.wallpapertrl.theme.ThemeManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTitleScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation DEFAULT_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/background/panorama_0.png");
    private ResourceLocation customBackground = ThemeManager.getBackgroundResource();
    private ResourceLocation buttonTextureNormal;
    private ResourceLocation buttonTextureHover;

    public CustomTitleScreen() {
        super((Component)Component.m_237115_((String)"menumod.screen.custom_title"));
        this.loadButtonTextures();
    }

    private void loadButtonTextures() {
        LOGGER.info("Loading button textures - Custom enabled: {}", (Object)ModConfig.useCustomButtons());
        ThemeManager.reloadThemeTextures(ThemeManager.getCurrentThemeName());
        this.buttonTextureNormal = ThemeManager.getButtonTexture("normal");
        this.buttonTextureHover = ThemeManager.getButtonTexture("hover");
        LOGGER.info("Loaded textures - Normal: {}, Hover: {}", (Object)this.buttonTextureNormal, (Object)this.buttonTextureHover);
    }

    private Button createCustomButton(Component text, int x, int y, Button.OnPress onPress) {
        if (ModConfig.useCustomButtons() && this.buttonTextureNormal != null && this.buttonTextureHover != null) {
            LOGGER.debug("Creating custom button with textures");
            return new CustomButton(x, y, ModConfig.getButtonWidth(), ModConfig.getButtonHeight(), text, onPress, this.buttonTextureNormal, this.buttonTextureHover);
        }
        LOGGER.debug("Creating standard button");
        return Button.m_253074_((Component)text, (Button.OnPress)onPress).m_252987_(x, y, ModConfig.getButtonWidth(), ModConfig.getButtonHeight()).m_253136_();
    }

    protected void m_7856_() {
        ThemeManager.reloadAllTextures();
        this.loadButtonTextures();
        if (ModConfig.enableButtonCustomization()) {
            this.initCustomButtons();
        } else {
            this.initDefaultButtons();
        }
    }

    private void initDefaultButtons() {
        int centerX = this.f_96543_ / 2;
        int baseY = this.f_96544_ / 4;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.singleplayer"), button -> this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this))).m_252987_(centerX - 100, baseY + 48, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.multiplayer"), button -> this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this))).m_252987_(centerX - 100, baseY + 72, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.options"), button -> this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_))).m_252987_(centerX - 100, baseY + 96, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.menu_settings"), button -> this.f_96541_.m_91152_((Screen)new ThemeConfigScreen(this))).m_252987_(centerX - 100, baseY + 120, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menumod.button.quit"), button -> this.f_96541_.m_91395_()).m_252987_(centerX - 100, baseY + 144, 200, 20).m_253136_());
    }

    private void initCustomButtons() {
        int centerX = this.f_96543_ / 2;
        int baseY = this.f_96544_ / 4;
        this.m_142416_((GuiEventListener)this.createCustomButton((Component)Component.m_237115_((String)"menumod.button.singleplayer"), centerX + ModConfig.getButtonSingleplayerX(), baseY + ModConfig.getButtonSingleplayerY(), button -> this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this))));
        this.m_142416_((GuiEventListener)this.createCustomButton((Component)Component.m_237115_((String)"menumod.button.multiplayer"), centerX + ModConfig.getButtonMultiplayerX(), baseY + ModConfig.getButtonMultiplayerY(), button -> this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this))));
        this.m_142416_((GuiEventListener)this.createCustomButton((Component)Component.m_237115_((String)"menumod.button.options"), centerX + ModConfig.getButtonOptionsX(), baseY + ModConfig.getButtonOptionsY(), button -> this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)this.createCustomButton((Component)Component.m_237115_((String)"menumod.button.menu_settings"), centerX + ModConfig.getButtonSettingsX(), baseY + ModConfig.getButtonSettingsY(), button -> this.f_96541_.m_91152_((Screen)new ThemeConfigScreen(this))));
        this.m_142416_((GuiEventListener)this.createCustomButton((Component)Component.m_237115_((String)"menumod.button.quit"), centerX + ModConfig.getButtonQuitX(), baseY + ModConfig.getButtonQuitY(), button -> this.f_96541_.m_91395_()));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
    }

    private void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.customBackground != null) {
            try {
                guiGraphics.m_280411_(this.customBackground, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            catch (Exception e) {
                guiGraphics.m_280411_(DEFAULT_BACKGROUND, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        } else {
            guiGraphics.m_280411_(DEFAULT_BACKGROUND, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void renderTitle(GuiGraphics guiGraphics) {
        MutableComponent title = Component.m_237115_((String)"menumod.screen.custom_title");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)title);
        int titleX = this.f_96543_ / 2 - titleWidth / 2;
        int titleY = 30;
        guiGraphics.m_280614_(this.f_96547_, (Component)title, titleX, titleY, 0xFFFFFF, true);
    }

    public void m_86600_() {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public String getButtonConfigInfo() {
        if (ModConfig.enableButtonCustomization()) {
            return String.format("", ModConfig.getButtonWidth(), ModConfig.getButtonHeight());
        }
        return "Default Layout";
    }
}

