/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.client.gui;

import com.troldg.wallpapertrl.client.gui.CustomTitleScreen;
import com.troldg.wallpapertrl.theme.ThemeManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntroScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private ResourceLocation introImage;
    private int displayTime = 0;
    private final int maxDisplayTime = 200;
    private boolean hasError = false;

    public IntroScreen() {
        super((Component)Component.m_237115_((String)"menumod.screen.intro"));
        String introPath = ThemeManager.getIntroPath();
        LOGGER.info("Initializing IntroScreen with path: {}", (Object)introPath);
        this.introImage = ThemeManager.getIntroResource();
        if (this.introImage == null) {
            LOGGER.error("Failed to load even default intro image!");
            this.hasError = true;
        } else {
            LOGGER.info("Intro image loaded successfully");
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.introImage != null) {
            guiGraphics.m_280411_(this.introImage, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 16, 16, 16);
        } else if (this.hasError) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menumod.message.intro_error"), this.f_96543_ / 2, this.f_96544_ / 2, -43691);
        }
        if (!this.hasError) {
            ++this.displayTime;
        }
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"menumod.tooltip.skip_intro"), this.f_96543_ / 2, this.f_96544_ - 30, 0xFFFFFF);
        if (!this.hasError && this.introImage != null) {
            int progressWidth = (int)((float)this.displayTime / 200.0f * 200.0f);
            int progressX = this.f_96543_ / 2 - 100;
            int progressY = this.f_96544_ - 50;
            guiGraphics.m_280509_(progressX, progressY, progressX + 200, progressY + 5, 0x66FFFFFF);
            guiGraphics.m_280509_(progressX, progressY, progressX + progressWidth, progressY + 5, -1);
        }
    }

    public void m_86600_() {
        if (!this.hasError && this.displayTime >= 200) {
            this.finishIntro();
        }
    }

    public boolean isFinished() {
        return this.displayTime >= 200 || this.hasError;
    }

    private void finishIntro() {
        LOGGER.info("Finishing intro, moving to main menu");
        this.f_96541_.m_91152_((Screen)new CustomTitleScreen());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.finishIntro();
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.finishIntro();
        return true;
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

