/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<String> THEME_NAME;
    public static final ForgeConfigSpec.ConfigValue<String> INTRO_PATH;
    public static final ForgeConfigSpec.ConfigValue<String> BACKGROUND_PATH;
    public static final ForgeConfigSpec.ConfigValue<String> MENU_MUSIC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CUSTOM_BUTTONS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BUTTON_CUSTOMIZATION;
    public static final ForgeConfigSpec.ConfigValue<String> BUTTON_TEXTURE_NORMAL;
    public static final ForgeConfigSpec.ConfigValue<String> BUTTON_TEXTURE_HOVER;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_SINGLEPLAYER_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_SINGLEPLAYER_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_MULTIPLAYER_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_MULTIPLAYER_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_OPTIONS_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_OPTIONS_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_SETTINGS_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_SETTINGS_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_QUIT_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_QUIT_Y;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_WIDTH;
    public static final ForgeConfigSpec.ConfigValue<Integer> BUTTON_HEIGHT;

    public static String getThemeName() {
        return (String)THEME_NAME.get();
    }

    public static String getIntroPath() {
        return (String)INTRO_PATH.get();
    }

    public static String getBackgroundPath() {
        return (String)BACKGROUND_PATH.get();
    }

    public static String getMenuMusic() {
        return (String)MENU_MUSIC.get();
    }

    public static boolean useCustomButtons() {
        return (Boolean)CUSTOM_BUTTONS.get();
    }

    public static boolean enableButtonCustomization() {
        return (Boolean)ENABLE_BUTTON_CUSTOMIZATION.get();
    }

    public static String getButtonTextureNormal() {
        return (String)BUTTON_TEXTURE_NORMAL.get();
    }

    public static String getButtonTextureHover() {
        return (String)BUTTON_TEXTURE_HOVER.get();
    }

    public static int getButtonSingleplayerX() {
        return (Integer)BUTTON_SINGLEPLAYER_X.get();
    }

    public static int getButtonSingleplayerY() {
        return (Integer)BUTTON_SINGLEPLAYER_Y.get();
    }

    public static int getButtonMultiplayerX() {
        return (Integer)BUTTON_MULTIPLAYER_X.get();
    }

    public static int getButtonMultiplayerY() {
        return (Integer)BUTTON_MULTIPLAYER_Y.get();
    }

    public static int getButtonOptionsX() {
        return (Integer)BUTTON_OPTIONS_X.get();
    }

    public static int getButtonOptionsY() {
        return (Integer)BUTTON_OPTIONS_Y.get();
    }

    public static int getButtonSettingsX() {
        return (Integer)BUTTON_SETTINGS_X.get();
    }

    public static int getButtonSettingsY() {
        return (Integer)BUTTON_SETTINGS_Y.get();
    }

    public static int getButtonQuitX() {
        return (Integer)BUTTON_QUIT_X.get();
    }

    public static int getButtonQuitY() {
        return (Integer)BUTTON_QUIT_Y.get();
    }

    public static int getButtonWidth() {
        return (Integer)BUTTON_WIDTH.get();
    }

    public static int getButtonHeight() {
        return (Integer)BUTTON_HEIGHT.get();
    }

    public static int getButtonX(String buttonType) {
        switch (buttonType) {
            case "singleplayer": {
                return ModConfig.getButtonSingleplayerX();
            }
            case "multiplayer": {
                return ModConfig.getButtonMultiplayerX();
            }
            case "options": {
                return ModConfig.getButtonOptionsX();
            }
            case "settings": {
                return ModConfig.getButtonSettingsX();
            }
            case "quit": {
                return ModConfig.getButtonQuitX();
            }
        }
        return -100;
    }

    public static int getButtonY(String buttonType) {
        switch (buttonType) {
            case "singleplayer": {
                return ModConfig.getButtonSingleplayerY();
            }
            case "multiplayer": {
                return ModConfig.getButtonMultiplayerY();
            }
            case "options": {
                return ModConfig.getButtonOptionsY();
            }
            case "settings": {
                return ModConfig.getButtonSettingsY();
            }
            case "quit": {
                return ModConfig.getButtonQuitY();
            }
        }
        return 48;
    }

    public static void setButtonPosition(String buttonType, int x, int y) {
        switch (buttonType) {
            case "singleplayer": {
                BUTTON_SINGLEPLAYER_X.set((Object)x);
                BUTTON_SINGLEPLAYER_Y.set((Object)y);
                break;
            }
            case "multiplayer": {
                BUTTON_MULTIPLAYER_X.set((Object)x);
                BUTTON_MULTIPLAYER_Y.set((Object)y);
                break;
            }
            case "options": {
                BUTTON_OPTIONS_X.set((Object)x);
                BUTTON_OPTIONS_Y.set((Object)y);
                break;
            }
            case "settings": {
                BUTTON_SETTINGS_X.set((Object)x);
                BUTTON_SETTINGS_Y.set((Object)y);
                break;
            }
            case "quit": {
                BUTTON_QUIT_X.set((Object)x);
                BUTTON_QUIT_Y.set((Object)y);
            }
        }
        SPEC.save();
    }

    public static void resetAllButtonPositions() {
        BUTTON_SINGLEPLAYER_X.set((Object)-100);
        BUTTON_SINGLEPLAYER_Y.set((Object)48);
        BUTTON_MULTIPLAYER_X.set((Object)-100);
        BUTTON_MULTIPLAYER_Y.set((Object)72);
        BUTTON_OPTIONS_X.set((Object)-100);
        BUTTON_OPTIONS_Y.set((Object)96);
        BUTTON_SETTINGS_X.set((Object)-100);
        BUTTON_SETTINGS_Y.set((Object)120);
        BUTTON_QUIT_X.set((Object)-100);
        BUTTON_QUIT_Y.set((Object)144);
        BUTTON_WIDTH.set((Object)200);
        BUTTON_HEIGHT.set((Object)20);
        BUTTON_TEXTURE_NORMAL.set((Object)"default/buttons/button_norm.png");
        BUTTON_TEXTURE_HOVER.set((Object)"default/buttons/button_hover.png");
        SPEC.save();
    }

    static {
        BUILDER.push("Theme Settings");
        THEME_NAME = BUILDER.comment("Name of your custom theme").define("themeName", (Object)"My Custom Theme");
        INTRO_PATH = BUILDER.comment("Path to intro file (in .minecraft/menumod/themes/ folder)").define("introPath", (Object)"default/intro.png");
        BACKGROUND_PATH = BUILDER.comment("Path to background image").define("backgroundPath", (Object)"default/background.png");
        MENU_MUSIC = BUILDER.comment("Path to custom menu music (optional)").define("menuMusic", (Object)"");
        CUSTOM_BUTTONS = BUILDER.comment("Use custom button textures (if available)").define("customButtons", true);
        BUILDER.pop();
        BUILDER.push("Button Customization");
        ENABLE_BUTTON_CUSTOMIZATION = BUILDER.comment("Enable custom button positions and textures").define("enableButtonCustomization", true);
        BUTTON_TEXTURE_NORMAL = BUILDER.comment("Path to normal button texture").define("buttonTextureNormal", (Object)"default/buttons/button_norm.png");
        BUTTON_TEXTURE_HOVER = BUILDER.comment("Path to hover button texture").define("buttonTextureHover", (Object)"default/buttons/button_hover.png");
        BUTTON_SINGLEPLAYER_X = BUILDER.comment("Singleplayer button X position (relative to center)").defineInRange("buttonSingleplayerX", -100, -1000, 1000);
        BUTTON_SINGLEPLAYER_Y = BUILDER.comment("Singleplayer button Y position (relative to height/4)").defineInRange("buttonSingleplayerY", 48, -1000, 1000);
        BUTTON_MULTIPLAYER_X = BUILDER.comment("Multiplayer button X position (relative to center)").defineInRange("buttonMultiplayerX", -100, -1000, 1000);
        BUTTON_MULTIPLAYER_Y = BUILDER.comment("Multiplayer button Y position (relative to height/4)").defineInRange("buttonMultiplayerY", 72, -1000, 1000);
        BUTTON_OPTIONS_X = BUILDER.comment("Options button X position (relative to center)").defineInRange("buttonOptionsX", -100, -1000, 1000);
        BUTTON_OPTIONS_Y = BUILDER.comment("Options button Y position (relative to height/4)").defineInRange("buttonOptionsY", 96, -1000, 1000);
        BUTTON_SETTINGS_X = BUILDER.comment("Menu Settings button X position (relative to center)").defineInRange("buttonSettingsX", -100, -1000, 1000);
        BUTTON_SETTINGS_Y = BUILDER.comment("Menu Settings button Y position (relative to height/4)").defineInRange("buttonSettingsY", 120, -1000, 1000);
        BUTTON_QUIT_X = BUILDER.comment("Quit button X position (relative to center)").defineInRange("buttonQuitX", -100, -1000, 1000);
        BUTTON_QUIT_Y = BUILDER.comment("Quit button Y position (relative to height/4)").defineInRange("buttonQuitY", 144, -1000, 1000);
        BUTTON_WIDTH = BUILDER.comment("Button width").defineInRange("buttonWidth", 200, 50, 1000);
        BUTTON_HEIGHT = BUILDER.comment("Button height").defineInRange("buttonHeight", 20, 10, 100);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class DefaultPositions {
        public static final int SINGLEPLAYER_X = -100;
        public static final int SINGLEPLAYER_Y = 48;
        public static final int MULTIPLAYER_X = -100;
        public static final int MULTIPLAYER_Y = 72;
        public static final int OPTIONS_X = -100;
        public static final int OPTIONS_Y = 96;
        public static final int SETTINGS_X = -100;
        public static final int SETTINGS_Y = 120;
        public static final int QUIT_X = -100;
        public static final int QUIT_Y = 144;
        public static final int WIDTH = 200;
        public static final int HEIGHT = 20;
    }
}

