/*
 * Decompiled with CFR 0.152.
 */
package com.troldg.wallpapertrl.theme;

import com.troldg.wallpapertrl.client.TextureLoader;
import com.troldg.wallpapertrl.config.ModConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThemeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File THEMES_FOLDER = new File(Minecraft.m_91087_().f_91069_, "menumod/themes");
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final Map<String, Long> TEXTURE_LOAD_TIME = new HashMap<String, Long>();
    private static final long CACHE_DURATION = 300000L;
    private static final ResourceLocation DEFAULT_INTRO = new ResourceLocation("menumod", "textures/themes/default/intro.png");
    private static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("menumod", "textures/themes/default/background.png");
    private static final ResourceLocation DEFAULT_BUTTON_NORMAL = new ResourceLocation("menumod", "textures/buttons/default/button_norm.png");
    private static final ResourceLocation DEFAULT_BUTTON_HOVER = new ResourceLocation("menumod", "textures/buttons/default/button_hover.png");

    public static void init() {
        if (!THEMES_FOLDER.exists()) {
            THEMES_FOLDER.mkdirs();
            ThemeManager.createDefaultTheme();
            ThemeManager.createExampleTheme();
            ThemeManager.createDefaultButtonTextures();
            ThemeManager.createReadmeFile();
            LOGGER.info("ThemeManager initialized. Themes folder: {}", (Object)THEMES_FOLDER.getAbsolutePath());
        } else {
            LOGGER.info("ThemeManager initialized. Using existing themes folder: {}", (Object)THEMES_FOLDER.getAbsolutePath());
        }
    }

    private static void createDefaultTheme() {
        try {
            File defaultTheme = new File(THEMES_FOLDER, "default");
            if (!defaultTheme.exists()) {
                defaultTheme.mkdirs();
                File instructions = new File(defaultTheme, "README.txt");
                FileWriter writer = new FileWriter(instructions);
                writer.write("This is your default theme folder!\n");
                writer.write("Put your custom files here:\n");
                writer.write("- intro.png (for intro screen)\n");
                writer.write("- background.png (for main menu)\n");
                writer.write("- buttons/ folder (for custom buttons)\n");
                writer.write("\nIf you don't add files, mod will use built-in defaults.\n");
                writer.close();
                LOGGER.info("Created default theme folder: {}", (Object)defaultTheme.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default theme", (Throwable)e);
        }
    }

    private static void createDefaultButtonTextures() {
        try {
            File defaultButtons = new File(THEMES_FOLDER, "default/buttons");
            if (!defaultButtons.exists()) {
                defaultButtons.mkdirs();
                File instructions = new File(defaultButtons, "README.txt");
                FileWriter writer = new FileWriter(instructions);
                writer.write("Button Textures Guide:\n");
                writer.write("======================\n\n");
                writer.write("Put your button texture files here:\n");
                writer.write("- button_norm.png (for normal state)\n");
                writer.write("- button_hover.png (for hover state)\n");
                writer.write("\nRecommended size: 200x20 pixels\n");
                writer.close();
                LOGGER.info("Created default buttons folder: {}", (Object)defaultButtons.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default buttons folder", (Throwable)e);
        }
    }

    private static void createExampleTheme() {
        try {
            File exampleTheme = new File(THEMES_FOLDER, "my_theme");
            if (!exampleTheme.exists()) {
                exampleTheme.mkdirs();
                File exampleReadme = new File(exampleTheme, "INSTRUCTIONS.txt");
                FileWriter writer = new FileWriter(exampleReadme);
                writer.write("Put your theme files here and set paths in game to:\n");
                writer.write("my_theme/intro.png\n");
                writer.write("my_theme/background.png\n");
                writer.write("my_theme/buttons/ (for custom buttons)\n");
                writer.write("\nSupported image formats: PNG, JPEG\n");
                writer.write("\nButton textures should go in: my_theme/buttons/\n");
                writer.write("Example button texture paths:\n");
                writer.write("my_theme/buttons/button_norm.png\n");
                writer.write("my_theme/buttons/button_hover.png\n");
                writer.close();
                LOGGER.info("Created example theme folder: {}", (Object)exampleTheme.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create example theme", (Throwable)e);
        }
    }

    private static void createReadmeFile() {
        try {
            File readme = new File(THEMES_FOLDER, "README.txt");
            FileWriter writer = new FileWriter(readme);
            writer.write("=== MenuMod Themes Guide ===\n\n");
            writer.write("BUTTON TEXTURES:\n");
            writer.write("- Create 'buttons' folder inside your theme\n");
            writer.write("- Add button_norm.png and button_hover.png files\n");
            writer.write("- Recommended size: 200x20 pixels\n");
            writer.write("- Enable 'Use Custom Buttons' in theme settings\n\n");
            writer.write("File Structure Example:\n");
            writer.write("themes/\n");
            writer.write("\u2514\u2500\u2500 default/\n");
            writer.write("    \u2514\u2500\u2500 buttons/\n");
            writer.write("        \u251c\u2500\u2500 button_norm.png\n");
            writer.write("        \u2514\u2500\u2500 button_hover.png\n");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create README file", (Throwable)e);
        }
    }

    public static ResourceLocation getIntroResource() {
        String introPath = ModConfig.getIntroPath();
        LOGGER.info("Loading intro resource from: {}", (Object)introPath);
        ResourceLocation customTexture = ThemeManager.loadTexture(introPath, true);
        if (customTexture != null) {
            return customTexture;
        }
        LOGGER.info("Using built-in default intro texture");
        return DEFAULT_INTRO;
    }

    public static ResourceLocation getBackgroundResource() {
        String backgroundPath = ModConfig.getBackgroundPath();
        LOGGER.info("Loading background resource from: {}", (Object)backgroundPath);
        ResourceLocation customTexture = ThemeManager.loadTexture(backgroundPath, true);
        if (customTexture != null) {
            return customTexture;
        }
        LOGGER.info("Using built-in default background texture");
        return DEFAULT_BACKGROUND;
    }

    public static ResourceLocation getButtonTexture(String buttonType) {
        if (!ModConfig.useCustomButtons()) {
            LOGGER.debug("Custom buttons disabled, using mod's default button textures");
            return ThemeManager.getDefaultButtonTexture(buttonType);
        }
        String themeName = ThemeManager.getCurrentThemeName();
        String fileName = "normal".equals(buttonType) ? "button_norm.png" : "button_hover.png";
        String buttonPath = themeName + "/buttons/" + fileName;
        LOGGER.debug("Loading custom button texture: {}", (Object)buttonPath);
        ResourceLocation customTexture = ThemeManager.loadTexture(buttonPath, true);
        if (customTexture != null) {
            LOGGER.info("Successfully loaded custom button texture: {}", (Object)buttonPath);
            return customTexture;
        }
        LOGGER.info("Custom button texture not found: {}, using mod's default", (Object)buttonPath);
        return ThemeManager.getDefaultButtonTexture(buttonType);
    }

    private static ResourceLocation getDefaultButtonTexture(String buttonType) {
        switch (buttonType) {
            case "normal": {
                return DEFAULT_BUTTON_NORMAL;
            }
            case "hover": {
                return DEFAULT_BUTTON_HOVER;
            }
        }
        LOGGER.warn("Unknown button type: {}, using normal", (Object)buttonType);
        return DEFAULT_BUTTON_NORMAL;
    }

    public static String getIntroPath() {
        return ModConfig.getIntroPath();
    }

    public static String getBackgroundPath() {
        return ModConfig.getBackgroundPath();
    }

    public static String getMenuMusicPath() {
        String musicPath = ModConfig.getMenuMusic();
        if (musicPath == null || musicPath.isEmpty()) {
            return null;
        }
        return new File(THEMES_FOLDER, musicPath).getAbsolutePath();
    }

    private static ResourceLocation loadTexture(String relativePath) {
        return ThemeManager.loadTexture(relativePath, false);
    }

    private static ResourceLocation loadTexture(String relativePath, boolean forceReload) {
        if (relativePath == null || relativePath.isEmpty() || relativePath.endsWith("/")) {
            LOGGER.warn("Invalid texture path: '{}' - must point to a file, not folder", (Object)relativePath);
            return null;
        }
        String cacheKey = relativePath.toLowerCase();
        if (forceReload) {
            TEXTURE_CACHE.remove(cacheKey);
            TEXTURE_LOAD_TIME.remove(cacheKey);
        } else {
            long currentTime = System.currentTimeMillis();
            if (TEXTURE_CACHE.containsKey(cacheKey)) {
                Long loadTime = TEXTURE_LOAD_TIME.get(cacheKey);
                if (loadTime != null && currentTime - loadTime < 300000L) {
                    LOGGER.debug("Using cached texture: {}", (Object)relativePath);
                    return TEXTURE_CACHE.get(cacheKey);
                }
                TEXTURE_CACHE.remove(cacheKey);
                TEXTURE_LOAD_TIME.remove(cacheKey);
            }
        }
        try {
            File textureFile = new File(THEMES_FOLDER, relativePath);
            LOGGER.info("Looking for texture file: {}", (Object)textureFile.getAbsolutePath());
            if (!textureFile.exists()) {
                LOGGER.warn("Texture file does not exist: {}", (Object)textureFile.getAbsolutePath());
                return null;
            }
            if (textureFile.isDirectory()) {
                LOGGER.warn("Path points to a directory, not a file: {}", (Object)relativePath);
                return null;
            }
            ResourceLocation texture = TextureLoader.loadTextureFromFile(textureFile);
            if (texture != null) {
                TEXTURE_CACHE.put(cacheKey, texture);
                TEXTURE_LOAD_TIME.put(cacheKey, System.currentTimeMillis());
                LOGGER.info("Successfully loaded custom texture: {}", (Object)relativePath);
                return texture;
            }
            LOGGER.error("Failed to load texture: {}", (Object)relativePath);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error loading texture: {}", (Object)relativePath, (Object)e);
            return null;
        }
    }

    public static String getCurrentThemeName() {
        String introPath = ModConfig.getIntroPath();
        if (introPath != null && introPath.contains("/")) {
            return introPath.substring(0, introPath.indexOf("/"));
        }
        String backgroundPath = ModConfig.getBackgroundPath();
        if (backgroundPath != null && backgroundPath.contains("/")) {
            return backgroundPath.substring(0, backgroundPath.indexOf("/"));
        }
        return "default";
    }

    public static File[] getAvailableThemes() {
        File[] themes = THEMES_FOLDER.listFiles(File::isDirectory);
        return themes != null ? themes : new File[]{};
    }

    public static boolean themeExists(String themeName) {
        if (themeName == null || themeName.isEmpty()) {
            return false;
        }
        File themeFolder = new File(THEMES_FOLDER, themeName);
        return themeFolder.exists() && themeFolder.isDirectory();
    }

    public static void clearCache() {
        TEXTURE_CACHE.clear();
        TEXTURE_LOAD_TIME.clear();
        LOGGER.info("Texture cache cleared");
    }

    public static void clearCacheForTheme(String themeName) {
        if (themeName == null) {
            return;
        }
        TEXTURE_CACHE.keySet().removeIf(key -> key.startsWith(themeName.toLowerCase() + "/"));
        TEXTURE_LOAD_TIME.keySet().removeIf(key -> key.startsWith(themeName.toLowerCase() + "/"));
        LOGGER.info("Cache cleared for theme: {}", (Object)themeName);
    }

    public static File getThemesFolder() {
        return THEMES_FOLDER;
    }

    public static boolean hasCustomButtonTextures() {
        if (!ModConfig.useCustomButtons()) {
            return false;
        }
        String themeName = ThemeManager.getCurrentThemeName();
        String normalPath = themeName + "/buttons/button_norm.png";
        String hoverPath = themeName + "/buttons/button_hover.png";
        File normalFile = new File(THEMES_FOLDER, normalPath);
        File hoverFile = new File(THEMES_FOLDER, hoverPath);
        return normalFile.exists() && hoverFile.exists();
    }

    public static String getButtonTextureInfo() {
        if (!ModConfig.useCustomButtons()) {
            return "Using default button textures";
        }
        if (ThemeManager.hasCustomButtonTextures()) {
            return "Using custom button textures";
        }
        return "Custom button textures not found, using defaults";
    }

    public static void reloadAllTextures() {
        ThemeManager.clearCache();
        LOGGER.info("All textures reloaded");
    }

    public static void reloadThemeTextures(String themeName) {
        ThemeManager.clearCacheForTheme(themeName);
        LOGGER.info("Textures reloaded for theme: {}", (Object)themeName);
    }
}

