/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api;

import com.leclowndu93150.chisel.api.carving.IChiselMode;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface IChiselItem {
    public boolean canOpenGui(Level var1, Player var2, InteractionHand var3);

    public ChiselGuiType getGuiType(Level var1, Player var2, InteractionHand var3);

    public boolean onChisel(Level var1, Player var2, ItemStack var3, Block var4);

    public boolean canChisel(Level var1, Player var2, ItemStack var3, ItemStack var4);

    public boolean canChiselBlock(Level var1, Player var2, InteractionHand var3, BlockPos var4, BlockState var5);

    public boolean supportsMode(Player var1, ItemStack var2, IChiselMode var3);

    public IChiselMode getMode(ItemStack var1);

    public ItemStack getTarget(ItemStack var1);

    public void openGui(Player var1, InteractionHand var2, ItemStack var3);

    @Nullable
    default public SoundEvent getOverrideSound(Level world, Player player, ItemStack chisel, Block target) {
        return null;
    }

    default public ItemStack craftItem(ItemStack chisel, ItemStack source, ItemStack target, Player player, EquipmentSlot slot) {
        if (chisel.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toCraft = Math.min(source.getCount(), target.getMaxStackSize());
        if (chisel.isDamageableItem()) {
            int damageLeft = chisel.getMaxDamage() - chisel.getDamageValue() + 1;
            toCraft = Math.min(toCraft, damageLeft);
            chisel.hurtAndBreak(toCraft, (LivingEntity)player, slot);
        }
        ItemStack res = target.copy();
        source.shrink(toCraft);
        res.setCount(toCraft);
        return res;
    }

    public static enum ChiselGuiType {
        NORMAL,
        HITECH;

    }
}

