/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.chunkdata;

import com.leclowndu93150.chisel.api.chunkdata.IOffsetData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class OffsetData
implements IOffsetData {
    private final Map<BlockPos, BlockPos> offsets = new HashMap<BlockPos, BlockPos>();

    @Override
    public BlockPos getOffset(BlockPos pos) {
        return this.offsets.getOrDefault(this.toChunkLocal(pos), BlockPos.ZERO);
    }

    public void setOffset(BlockPos pos, BlockPos offset) {
        BlockPos local = this.toChunkLocal(pos);
        if (offset.equals((Object)BlockPos.ZERO)) {
            this.offsets.remove(local);
        } else {
            this.offsets.put(local, this.wrap(offset));
        }
    }

    public void move(BlockPos pos, Direction dir) {
        BlockPos local = this.toChunkLocal(pos);
        BlockPos current = this.offsets.getOrDefault(local, BlockPos.ZERO);
        BlockPos newOffset = this.wrap(current.relative(dir.getOpposite()));
        if (newOffset.equals((Object)BlockPos.ZERO)) {
            this.offsets.remove(local);
        } else {
            this.offsets.put(local, newOffset);
        }
    }

    public void setOffsetForAll(Set<BlockPos> positions, BlockPos offset) {
        BlockPos wrapped = this.wrap(offset);
        for (BlockPos pos : positions) {
            BlockPos local = this.toChunkLocal(pos);
            if (wrapped.equals((Object)BlockPos.ZERO)) {
                this.offsets.remove(local);
                continue;
            }
            this.offsets.put(local, wrapped);
        }
    }

    public void moveAll(Set<BlockPos> positions, Direction dir) {
        BlockPos firstLocal = null;
        Iterator<BlockPos> iterator = positions.iterator();
        if (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            firstLocal = this.toChunkLocal(pos);
        }
        if (firstLocal == null) {
            return;
        }
        BlockPos current = this.offsets.getOrDefault(firstLocal, BlockPos.ZERO);
        BlockPos newOffset = this.wrap(current.relative(dir.getOpposite()));
        for (BlockPos pos : positions) {
            BlockPos local = this.toChunkLocal(pos);
            if (newOffset.equals((Object)BlockPos.ZERO)) {
                this.offsets.remove(local);
                continue;
            }
            this.offsets.put(local, newOffset);
        }
    }

    public boolean isEmpty() {
        return this.offsets.isEmpty();
    }

    private BlockPos toChunkLocal(BlockPos pos) {
        return new BlockPos(pos.getX() & 0xF, pos.getY(), pos.getZ() & 0xF);
    }

    private int positiveModulo(int num, int denom) {
        return (num % denom + denom) % denom;
    }

    private BlockPos wrap(BlockPos pos) {
        return new BlockPos(this.positiveModulo(pos.getX(), 16), this.positiveModulo(pos.getY(), 16), this.positiveModulo(pos.getZ(), 16));
    }

    public void writeToNBT(CompoundTag tag) {
        if (this.offsets.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, BlockPos> entry : this.offsets.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            BlockPos pos = entry.getKey();
            BlockPos offset = entry.getValue();
            entryTag.putInt("pos", pos.getX() << 28 | (pos.getY() & 0xFFFFFF) << 4 | pos.getZ());
            entryTag.putShort("off", (short)(offset.getX() << 8 | offset.getY() << 4 | offset.getZ()));
            list.add((Object)entryTag);
        }
        tag.put("offsets", (Tag)list);
    }

    public void readFromNBT(CompoundTag tag) {
        this.offsets.clear();
        if (!tag.contains("offsets", 9)) {
            return;
        }
        ListTag list = tag.getList("offsets", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entryTag = list.getCompound(i);
            int packedPos = entryTag.getInt("pos");
            int x = packedPos >> 28 & 0xF;
            int y = packedPos >> 4 & 0xFFFFFF;
            int z = packedPos & 0xF;
            if ((y & 0x800000) != 0) {
                y |= 0xFF000000;
            }
            BlockPos pos = new BlockPos(x, y, z);
            short packedOffset = entryTag.getShort("off");
            BlockPos offset = new BlockPos(packedOffset >> 8 & 0xF, packedOffset >> 4 & 0xF, packedOffset & 0xF);
            this.offsets.put(pos, offset);
        }
    }

    public OffsetData copy() {
        OffsetData copy = new OffsetData();
        copy.offsets.putAll(this.offsets);
        return copy;
    }
}

