/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.block.entity;

import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselBlockEntities;
import com.leclowndu93150.chisel.inventory.AutoChiselMenu;
import com.leclowndu93150.chisel.network.AutoChiselFXPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AutoChiselBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int INPUT_SLOTS = 12;
    public static final int OUTPUT_SLOTS = 12;
    private static final int MAX_PROGRESS = 1024;
    private static final int BASE_PROGRESS = 16;
    private static final int SPEEDUP_PROGRESS = 64;
    private static final int POWER_PER_TICK = 20;
    private static final int MAX_ENERGY = 10000;
    private final ItemStackHandler chiselSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() instanceof IChiselItem;
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler targetSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return CarvingHelper.canChisel(stack);
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler inputInv = new ItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            return CarvingHelper.canChisel(stack);
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler outputInv = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.setChanged();
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 40, 20);
    private int progress = 0;
    private int sourceSlot = -1;
    private Component customName;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (AutoChiselBlockEntity.this.sourceSlot >= 0) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> AutoChiselBlockEntity.this.progress;
                case 2 -> 1024;
                case 3 -> AutoChiselBlockEntity.this.energyStorage.getEnergyStored();
                case 4 -> AutoChiselBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 5 -> AutoChiselBlockEntity.this.getUsagePerTick();
                default -> 0;
            };
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 6;
        }
    };

    public AutoChiselBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ChiselBlockEntities.AUTO_CHISEL.get(), pos, state);
    }

    public void tick() {
        ItemStack result;
        TagKey<Item> sourceGroup;
        TagKey<Item> targetGroup;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.energyStorage.getEnergyStored() == 0 && ChiselConfig.autoChiselNeedsPower) {
            return;
        }
        ItemStack target = this.targetSlot.getStackInSlot(0);
        ItemStack chisel = this.chiselSlot.getStackInSlot(0);
        ItemStack source = this.sourceSlot >= 0 ? this.inputInv.getStackInSlot(this.sourceSlot) : ItemStack.EMPTY;
        TagKey<Item> tagKey = targetGroup = target.isEmpty() || chisel.isEmpty() ? null : CarvingHelper.getCarvingGroupForItem(target);
        if (chisel.isEmpty() || targetGroup == null) {
            this.sourceSlot = -1;
            this.progress = 0;
            return;
        }
        if (!(source.isEmpty() || (sourceGroup = CarvingHelper.getCarvingGroupForItem(source)) != null && sourceGroup.equals(targetGroup))) {
            source = ItemStack.EMPTY;
        }
        if (this.sourceSlot < 0 && this.level.getGameTime() % 20L == 0L || this.sourceSlot >= 0) {
            if (source.isEmpty()) {
                this.sourceSlot = -1;
            }
            result = new ItemStack((ItemLike)target.getItem());
            if (!source.isEmpty()) {
                result.setCount(source.getCount());
            }
            if (source.isEmpty() || this.canOutput(result)) {
                for (int i = 0; this.sourceSlot < 0 && i < this.inputInv.getSlots(); ++i) {
                    TagKey<Item> stackGroup;
                    ItemStack stack = this.inputInv.getStackInSlot(i);
                    if (stack.isEmpty() || (stackGroup = CarvingHelper.getCarvingGroupForItem(stack)) == null || !stackGroup.equals(targetGroup)) continue;
                    result.setCount(stack.getCount());
                    if (!this.canOutput(result)) continue;
                    this.sourceSlot = i;
                    source = stack.copy();
                }
            } else {
                this.sourceSlot = -1;
            }
        }
        if (this.sourceSlot >= 0) {
            source = this.inputInv.getStackInSlot(this.sourceSlot);
            if (!ItemStack.isSameItem((ItemStack)source, (ItemStack)target)) {
                if (this.progress < 1024) {
                    if (!ChiselConfig.autoChiselNeedsPower) {
                        this.progress = Math.min(1024, this.progress + 16);
                    }
                    int toUse = Math.min(1024 - this.progress, this.getPowerProgressPerTick());
                    int powerToUse = this.getUsagePerTick();
                    if (toUse > 0 && powerToUse > 0) {
                        if (ChiselConfig.autoChiselPowered) {
                            int used = this.energyStorage.extractEnergy(powerToUse, false);
                            this.progress += (int)((float)toUse * ((float)used / (float)powerToUse));
                        } else {
                            this.progress += toUse;
                        }
                    }
                } else {
                    result = new ItemStack((ItemLike)target.getItem(), source.getCount());
                    this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.EMPTY);
                    if (ChiselConfig.allowChiselDamage && chisel.isDamageableItem()) {
                        chisel.setDamageValue(chisel.getDamageValue() + 1);
                        if (chisel.getDamageValue() >= chisel.getMaxDamage()) {
                            this.chiselSlot.setStackInSlot(0, ItemStack.EMPTY);
                        }
                    }
                    this.mergeOutput(result);
                    Level used = this.level;
                    if (used instanceof ServerLevel) {
                        BlockState blockState;
                        ServerLevel serverLevel = (ServerLevel)used;
                        Item item = result.getItem();
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            blockState = blockItem.getBlock().defaultBlockState();
                        } else {
                            blockState = Blocks.STONE.defaultBlockState();
                        }
                        BlockState resultState = blockState;
                        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)serverLevel.getChunk(this.worldPosition).getPos(), (CustomPacketPayload)new AutoChiselFXPayload(this.worldPosition, chisel.copy(), resultState), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    this.sourceSlot = (this.sourceSlot + 1) % this.inputInv.getSlots();
                    this.progress = 0;
                }
            } else {
                this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.EMPTY);
                this.mergeOutput(source);
            }
        } else {
            this.progress = 0;
        }
    }

    private float getSpeedFactor() {
        return ChiselConfig.autoChiselPowered ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : 1.0f;
    }

    private int getPowerProgressPerTick() {
        int maxPerTick = ChiselConfig.autoChiselNeedsPower ? 80 : 64;
        return (int)Math.ceil(this.getSpeedFactor() * (float)maxPerTick);
    }

    private int getUsagePerTick() {
        return (int)Math.ceil(this.getSpeedFactor() * 20.0f);
    }

    private boolean canOutput(ItemStack stack) {
        ItemStack remaining = stack.copy();
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (!(remaining = this.outputInv.insertItem(i, remaining, true)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void mergeOutput(ItemStack stack) {
        for (int i = 0; i < this.outputInv.getSlots() && !stack.isEmpty(); ++i) {
            stack = this.outputInv.insertItem(i, stack, false);
        }
    }

    public void dropContents(Level level, BlockPos pos) {
        int i;
        for (i = 0; i < this.inputInv.getSlots(); ++i) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.inputInv.getStackInSlot(i));
        }
        for (i = 0; i < this.outputInv.getSlots(); ++i) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.outputInv.getStackInSlot(i));
        }
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.chiselSlot.getStackInSlot(0));
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.targetSlot.getStackInSlot(0));
    }

    public ItemStackHandler getChiselSlot() {
        return this.chiselSlot;
    }

    public ItemStackHandler getTargetSlot() {
        return this.targetSlot;
    }

    public ItemStackHandler getInputInv() {
        return this.inputInv;
    }

    public ItemStackHandler getOutputInv() {
        return this.outputInv;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("chisel", (Tag)this.chiselSlot.serializeNBT(registries));
        tag.put("target", (Tag)this.targetSlot.serializeNBT(registries));
        tag.put("input", (Tag)this.inputInv.serializeNBT(registries));
        tag.put("output", (Tag)this.outputInv.serializeNBT(registries));
        tag.putInt("energy", this.energyStorage.getEnergyStored());
        tag.putInt("progress", this.progress);
        tag.putInt("source", this.sourceSlot);
        if (this.customName != null) {
            tag.putString("customName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.chiselSlot.deserializeNBT(registries, tag.getCompound("chisel"));
        this.targetSlot.deserializeNBT(registries, tag.getCompound("target"));
        this.inputInv.deserializeNBT(registries, tag.getCompound("input"));
        this.outputInv.deserializeNBT(registries, tag.getCompound("output"));
        this.energyStorage.receiveEnergy(tag.getInt("energy") - this.energyStorage.getEnergyStored(), false);
        this.progress = tag.getInt("progress");
        this.sourceSlot = tag.getInt("source");
        if (tag.contains("customName")) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("customName"), (HolderLookup.Provider)registries);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.getCustomName() : this.getName();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getBlockState().getBlock().getName();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player player) {
        return new AutoChiselMenu(containerId, playerInv, this, this.dataAccess, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }
}

