/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.carving;

import com.leclowndu93150.chisel.api.carving.ICarvingGroup;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class KubeJSCarvingGroup
implements ICarvingGroup {
    private final ResourceLocation groupId;
    private final Set<ResourceLocation> blocks;

    public KubeJSCarvingGroup(ResourceLocation groupId, Set<ResourceLocation> blocks) {
        this.groupId = groupId;
        this.blocks = blocks;
    }

    @Override
    public ResourceLocation getId() {
        return this.groupId;
    }

    @Override
    public String getTranslationKey() {
        String path = this.groupId.getPath();
        if (path.startsWith("carving/")) {
            path = path.substring("carving/".length());
        }
        return "chisel.group." + path;
    }

    @Override
    public TagKey<Item> getItemTag() {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.groupId);
    }

    @Override
    public TagKey<Block> getBlockTag() {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.groupId);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.STONE_BREAK;
    }

    public Set<ResourceLocation> getBlocks() {
        return this.blocks;
    }
}

