/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client;

import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.chunkdata.ChunkData;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.Map;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.chisel.ctm.client.texture.ctx.OffsetProviderRegistry;

@EventBusSubscriber(modid="chisel", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ChiselClientEvents {
    private static final int DEFAULT_WATER_COLOR = 4159204;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> OffsetProviderRegistry.INSTANCE.registerProvider((world, pos) -> ChunkData.getOffsetData(world, pos).getOffset(pos)));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        for (Map.Entry<DyeColor, ChiselBlockType<BlockCarvable>> entry : ChiselBlocks.HEX_PLATING.entrySet()) {
            DyeColor color = entry.getKey();
            ChiselBlockType<BlockCarvable> blockType = entry.getValue();
            Block[] blocks = (Block[])blockType.getAllBlocks().stream().map(DeferredHolder::get).toArray(Block[]::new);
            event.register((state, level, pos, tintIndex) -> tintIndex == 1 ? color.getTextColor() : -1, blocks);
        }
        Block[] waterstoneBlocks = (Block[])ChiselBlocks.WATERSTONE.getAllBlocks().stream().map(DeferredHolder::get).toArray(Block[]::new);
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return level != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : 4159204;
            }
            return -1;
        }, waterstoneBlocks);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (Map.Entry<DyeColor, ChiselBlockType<BlockCarvable>> entry : ChiselBlocks.HEX_PLATING.entrySet()) {
            DyeColor color = entry.getKey();
            ChiselBlockType<BlockCarvable> blockType = entry.getValue();
            Item[] items = (Item[])blockType.getAllBlocks().stream().map(block -> ((Block)block.get()).asItem()).toArray(Item[]::new);
            event.register((stack, tintIndex) -> tintIndex == 1 ? color.getTextColor() : -1, (ItemLike[])items);
        }
        Item[] waterstoneItems = (Item[])ChiselBlocks.WATERSTONE.getAllBlocks().stream().map(block -> ((BlockCarvable)block.get()).asItem()).toArray(Item[]::new);
        event.register((stack, tintIndex) -> tintIndex == 1 ? 4159204 : -1, (ItemLike[])waterstoneItems);
    }
}

