/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.gui;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.init.ChiselItems;
import com.leclowndu93150.chisel.inventory.AutoChiselMenu;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AutoChiselScreen
extends AbstractContainerScreen<AutoChiselMenu> {
    private static final ResourceLocation TEXTURE = Chisel.id("textures/gui/autochisel.png");
    private static final int PROG_BAR_LENGTH = 50;
    private static final int POWER_BAR_LENGTH = 160;
    private final ItemStack fakeChisel;

    public AutoChiselScreen(AutoChiselMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.imageHeight = 200;
        this.fakeChisel = new ItemStack((ItemLike)ChiselItems.IRON_CHISEL.get());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((AutoChiselMenu)this.menu).isActive()) {
            int scaledProg = ((AutoChiselMenu)this.menu).getProgressScaled(50);
            graphics.blit(TEXTURE, this.leftPos + 63, this.topPos + 19 + 9, 176, 18, scaledProg + 1, 16);
        }
        if (ChiselConfig.autoChiselPowered) {
            graphics.blit(TEXTURE, this.leftPos + 7, this.topPos + 93, 7, 200, 162, 6);
            if (((AutoChiselMenu)this.menu).hasEnergy()) {
                graphics.blit(TEXTURE, this.leftPos + 8, this.topPos + 94, 8, 206, ((AutoChiselMenu)this.menu).getEnergyScaled(160) + 1, 4);
            }
        }
        if (!((AutoChiselMenu)this.menu).getSlot(((AutoChiselMenu)this.menu).chiselSlot).hasItem()) {
            this.drawGhostItem(graphics, this.fakeChisel, this.leftPos + 80, this.topPos + 28);
        }
        if (!((AutoChiselMenu)this.menu).getSlot(((AutoChiselMenu)this.menu).targetSlot).hasItem()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(TEXTURE, this.leftPos + 80, this.topPos + 64, 176, 34, 16, 16);
        }
    }

    private void drawGhostItem(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.renderItem(stack, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        Lighting.setupForFlatItems();
        graphics.blit(TEXTURE, x, y, x - this.leftPos, y - this.topPos, 16, 16);
        Lighting.setupFor3DItems();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (ChiselConfig.autoChiselPowered) {
            int localMouseX = mouseX - this.leftPos;
            int localMouseY = mouseY - this.topPos;
            if (localMouseX >= 7 && localMouseY >= 93 && localMouseX <= 169 && localMouseY <= 98) {
                NumberFormat fmt = NumberFormat.getNumberInstance();
                String stored = fmt.format(((AutoChiselMenu)this.menu).getEnergy());
                String max = fmt.format(((AutoChiselMenu)this.menu).getMaxEnergy());
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.translatable((String)"chisel.tooltip.power.stored", (Object[])new Object[]{stored, max}));
                tooltip.add(Component.translatable((String)"chisel.tooltip.power.pertick", (Object[])new Object[]{fmt.format(((AutoChiselMenu)this.menu).getUsagePerTick())}).withStyle(ChatFormatting.GRAY));
                graphics.renderComponentTooltip(this.font, tooltip, localMouseX, localMouseY);
            }
        }
    }
}

