/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat.kubejs;

import com.leclowndu93150.chisel.compat.kubejs.CarvingGroupBuilder;
import com.leclowndu93150.chisel.compat.kubejs.ChiselKubeJSEvents;
import com.leclowndu93150.chisel.compat.kubejs.ModifyCarvingGroupsEvent;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class KubeJSEventHandler {
    private static boolean registered = false;
    private static ModifyCarvingGroupsEvent lastEvent = null;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.addListener(KubeJSEventHandler::onTagsUpdated);
    }

    private static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            KubeJSEventHandler.fireModifyGroupsEvent();
        }
    }

    public static void fireModifyGroupsEvent() {
        ModifyCarvingGroupsEvent kubeEvent = new ModifyCarvingGroupsEvent();
        ChiselKubeJSEvents.MODIFY_GROUPS.post((ScriptTypeHolder)ScriptType.SERVER, (KubeEvent)kubeEvent);
        lastEvent = kubeEvent;
    }

    public static Boolean shouldIncludeBlock(TagKey<Block> groupTag, Block block) {
        if (lastEvent == null) {
            return null;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation groupId = groupTag.location();
        if (lastEvent.getBlocksRemovedFromAll().contains(blockId)) {
            return false;
        }
        if (lastEvent.getRemovedGroups().contains(groupId)) {
            return false;
        }
        CarvingGroupBuilder builder = lastEvent.getGroups().get(groupId);
        if (builder != null) {
            if (builder.shouldClearExisting() && !builder.getBlocksToAdd().contains(blockId)) {
                return false;
            }
            if (builder.getBlocksToRemove().contains(blockId)) {
                return false;
            }
            if (builder.getBlocksToAdd().contains(blockId)) {
                return true;
            }
        }
        return null;
    }

    public static Set<ResourceLocation> getAdditionalBlocks(TagKey<Block> groupTag) {
        if (lastEvent == null) {
            return Collections.emptySet();
        }
        ResourceLocation groupId = groupTag.location();
        CarvingGroupBuilder builder = lastEvent.getGroups().get(groupId);
        if (builder != null) {
            return builder.getBlocksToAdd();
        }
        for (Map.Entry<ResourceLocation, CarvingGroupBuilder> entry : lastEvent.getGroups().entrySet()) {
            if (!entry.getKey().equals((Object)groupId) && (!entry.getKey().getNamespace().equals("chisel") || !groupId.getPath().equals(entry.getKey().getPath()))) continue;
            return entry.getValue().getBlocksToAdd();
        }
        return Collections.emptySet();
    }

    public static Map<ResourceLocation, CarvingGroupBuilder> getCustomGroups() {
        if (lastEvent == null) {
            return Collections.emptyMap();
        }
        return lastEvent.getGroups();
    }

    public static boolean isGroupRemoved(ResourceLocation groupId) {
        return lastEvent != null && lastEvent.getRemovedGroups().contains(groupId);
    }

    @Nullable
    public static TagKey<Block> getGroupForBlock(Block block) {
        if (lastEvent == null) {
            return null;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        for (Map.Entry<ResourceLocation, CarvingGroupBuilder> entry : lastEvent.getGroups().entrySet()) {
            CarvingGroupBuilder builder = entry.getValue();
            if (!builder.getBlocksToAdd().contains(blockId)) continue;
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)entry.getKey());
        }
        return null;
    }

    public static void clearCache() {
        lastEvent = null;
    }
}

