/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ChiselData(String mode, int previewType, int selectionSlot, int targetSlot, boolean rotate, ItemStack target) {
    public static final ChiselData DEFAULT = new ChiselData("single", 0, -1, -1, false, ItemStack.EMPTY);
    public static final Codec<ChiselData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("mode").forGetter(ChiselData::mode), (App)Codec.INT.fieldOf("preview_type").forGetter(ChiselData::previewType), (App)Codec.INT.fieldOf("selection_slot").forGetter(ChiselData::selectionSlot), (App)Codec.INT.fieldOf("target_slot").forGetter(ChiselData::targetSlot), (App)Codec.BOOL.fieldOf("rotate").forGetter(ChiselData::rotate), (App)ItemStack.OPTIONAL_CODEC.fieldOf("target").forGetter(ChiselData::target)).apply((Applicative)instance, ChiselData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChiselData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ChiselData::mode, (StreamCodec)ByteBufCodecs.VAR_INT, ChiselData::previewType, (StreamCodec)ByteBufCodecs.VAR_INT, ChiselData::selectionSlot, (StreamCodec)ByteBufCodecs.VAR_INT, ChiselData::targetSlot, (StreamCodec)ByteBufCodecs.BOOL, ChiselData::rotate, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ChiselData::target, ChiselData::new);

    public ChiselData withMode(String newMode) {
        return new ChiselData(newMode, this.previewType, this.selectionSlot, this.targetSlot, this.rotate, this.target);
    }

    public ChiselData withPreviewType(int newPreviewType) {
        return new ChiselData(this.mode, newPreviewType, this.selectionSlot, this.targetSlot, this.rotate, this.target);
    }

    public ChiselData withSelectionSlot(int newSelectionSlot) {
        return new ChiselData(this.mode, this.previewType, newSelectionSlot, this.targetSlot, this.rotate, this.target);
    }

    public ChiselData withTargetSlot(int newTargetSlot) {
        return new ChiselData(this.mode, this.previewType, this.selectionSlot, newTargetSlot, this.rotate, this.target);
    }

    public ChiselData withRotate(boolean newRotate) {
        return new ChiselData(this.mode, this.previewType, this.selectionSlot, this.targetSlot, newRotate, this.target);
    }

    public ChiselData withTarget(ItemStack newTarget) {
        return new ChiselData(this.mode, this.previewType, this.selectionSlot, this.targetSlot, this.rotate, newTarget.copy());
    }
}

