/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ChiselBlockTagsProvider
extends BlockTagsProvider {
    public ChiselBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "chisel", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            TagKey<Block> carvingTag = blockType.getCarvingGroupTag();
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tagBuilder = this.tag(carvingTag);
            for (DeferredBlock<?> deferredBlock : blockType.getAllBlocks()) {
                tagBuilder.add((Object)((Block)deferredBlock.get()));
            }
            for (ResourceLocation resourceLocation : blockType.getVanillaBlocks()) {
                tagBuilder.addOptional(resourceLocation);
            }
            for (TagKey tagKey : blockType.getSourceBlockTags()) {
                tagBuilder.addOptionalTag(tagKey);
            }
            for (TagKey tagKey : blockType.getBlockTags()) {
                IntrinsicHolderTagsProvider.IntrinsicTagAppender miningTagBuilder = this.tag(tagKey);
                for (DeferredBlock<?> block : blockType.getAllBlocks()) {
                    miningTagBuilder.add((Object)((Block)block.get()));
                }
            }
        }
    }
}

