/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ChiselLootTableProvider
extends LootTableProvider {
    public ChiselLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChiselBlockLoot::new, LootContextParamSets.BLOCK)), registries);
    }

    private static class ChiselBlockLoot
    extends BlockLootSubProvider {
        protected ChiselBlockLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
                for (DeferredBlock<?> deferredBlock : blockType.getAllBlocks()) {
                    Block block = (Block)deferredBlock.get();
                    this.dropSelf(block);
                }
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return ChiselBlocks.getAllBlocks().stream().map(DeferredHolder::get).map(block -> block).toList();
        }
    }
}

