/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.block.entity.AutoChiselBlockEntity;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AutoChiselMenu
extends AbstractContainerMenu {
    public static final int ACTIVE = 0;
    public static final int PROGRESS = 1;
    public static final int MAX_PROGRESS = 2;
    public static final int ENERGY = 3;
    public static final int MAX_ENERGY = 4;
    public static final int ENERGY_USE = 5;
    public final Inventory playerInventory;
    public final int chiselSlot;
    public final int targetSlot;
    private final int beginInputSlots;
    private final int endInputSlots;
    private final int beginOutputSlots;
    private final int endOutputSlots;
    private final int beginPlayerSlots;
    private final int endPlayerSlots;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public AutoChiselMenu(int containerId, Inventory playerInv, FriendlyByteBuf buf) {
        this(containerId, playerInv, (IItemHandler)new ItemStackHandler(1), (IItemHandler)new ItemStackHandler(1), (IItemHandler)new ItemStackHandler(12), (IItemHandler)new ItemStackHandler(12), (ContainerData)new SimpleContainerData(6), ContainerLevelAccess.NULL);
    }

    public AutoChiselMenu(int containerId, Inventory playerInv, AutoChiselBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        this(containerId, playerInv, (IItemHandler)blockEntity.getChiselSlot(), (IItemHandler)blockEntity.getTargetSlot(), (IItemHandler)blockEntity.getInputInv(), (IItemHandler)blockEntity.getOutputInv(), data, access);
    }

    public AutoChiselMenu(int containerId, Inventory playerInv, IItemHandler chisel, IItemHandler target, IItemHandler input, IItemHandler output, ContainerData data, ContainerLevelAccess access) {
        super((MenuType)ChiselMenus.AUTO_CHISEL_MENU.get(), containerId);
        int y;
        int x;
        int i;
        this.playerInventory = playerInv;
        this.data = data;
        this.access = access;
        int yStart = 19;
        this.chiselSlot = 0;
        this.addSlot((Slot)new SlotItemHandler(this, chisel, 0, 80, yStart + 9){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof IChiselItem;
            }
        });
        this.targetSlot = 1;
        this.addSlot((Slot)new SlotItemHandler(this, target, 0, 80, 54 + yStart - 9){

            public boolean mayPlace(ItemStack stack) {
                return CarvingHelper.canChisel(stack);
            }
        });
        this.beginInputSlots = this.slots.size();
        for (i = 0; i < input.getSlots(); ++i) {
            x = 8 + 18 * (i % 3);
            y = yStart + 18 * (i / 3);
            this.addSlot((Slot)new SlotItemHandler(this, input, i, x, y){

                public boolean mayPlace(ItemStack stack) {
                    return CarvingHelper.canChisel(stack);
                }
            });
        }
        this.endInputSlots = this.beginOutputSlots = this.slots.size();
        for (i = 0; i < output.getSlots(); ++i) {
            x = 116 + 18 * (i % 3);
            y = yStart + 18 * (i / 3);
            this.addSlot((Slot)new SlotItemHandler(this, output, i, x, y){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
        }
        this.beginPlayerSlots = this.endOutputSlots = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 118 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 176));
        }
        this.endPlayerSlots = this.slots.size();
        this.addDataSlots(data);
    }

    public boolean stillValid(Player player) {
        return AutoChiselMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ChiselBlocks.AUTO_CHISEL.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (index >= this.beginOutputSlots && index < this.endOutputSlots) {
                if (!this.moveItemStackTo(slotStack, this.beginPlayerSlots, this.endPlayerSlots, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, result);
            } else if (index >= this.beginPlayerSlots ? (CarvingHelper.canChisel(slotStack) ? !this.moveItemStackTo(slotStack, this.targetSlot, this.targetSlot + 1, false) && !this.moveItemStackTo(slotStack, this.beginInputSlots, this.endInputSlots, false) : (slotStack.getItem() instanceof IChiselItem ? !this.moveItemStackTo(slotStack, this.chiselSlot, this.chiselSlot + 1, false) : (index >= this.beginPlayerSlots && index < this.endPlayerSlots - 9 ? !this.moveItemStackTo(slotStack, this.endPlayerSlots - 9, this.endPlayerSlots, false) : index >= this.endPlayerSlots - 9 && index < this.endPlayerSlots && !this.moveItemStackTo(slotStack, this.beginPlayerSlots, this.endPlayerSlots - 9, false)))) : !this.moveItemStackTo(slotStack, this.beginPlayerSlots, this.endPlayerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return result;
    }

    public boolean isActive() {
        return this.data.get(0) > 0;
    }

    public int getProgressScaled(int barLength) {
        int progress = this.data.get(1);
        int maxProgress = this.data.get(2);
        return maxProgress > 0 ? (int)((float)progress / (float)maxProgress * (float)barLength) : 0;
    }

    public boolean hasEnergy() {
        return this.getEnergy() > 0;
    }

    public int getEnergy() {
        return this.data.get(3);
    }

    public int getMaxEnergy() {
        return this.data.get(4);
    }

    public int getEnergyScaled(int barLength) {
        int energy = this.data.get(3);
        int maxEnergy = this.data.get(4);
        return maxEnergy > 0 ? (int)((float)energy / (float)maxEnergy * (float)barLength) : 0;
    }

    public int getUsagePerTick() {
        return this.data.get(5);
    }
}

