/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.google.common.collect.ImmutableList;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;

public class HitechChiselMenu
extends ChiselMenu {
    public static final int HITECH_SELECTION_ROWS = 7;
    public static final int HITECH_SELECTION_COLS = 9;
    public static final int HITECH_SELECTION_SIZE = 63;
    public static final int HITECH_SELECTION_LEFT = 88;
    public static final int HITECH_SELECTION_TOP = 8;
    public static final int HITECH_INPUT_X = -1000;
    public static final int HITECH_INPUT_Y = 0;
    public static final int HITECH_PLAYER_INV_LEFT = 88;
    public static final int HITECH_PLAYER_INV_TOP = 138;
    public static final int HITECH_HOTBAR_TOP = 196;
    @Nullable
    private Slot selection;
    @Nullable
    private Slot target;
    private List<Slot> selectionDuplicates = ImmutableList.of();
    @Nullable
    private TagKey<Item> currentGroup;
    public static Supplier<MenuType<HitechChiselMenu>> MENU_TYPE_SUPPLIER;

    public HitechChiselMenu(int containerId, Inventory playerInv, FriendlyByteBuf buf) {
        this(containerId, playerInv, buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public HitechChiselMenu(int containerId, Inventory playerInv, InteractionHand hand) {
        super(MENU_TYPE_SUPPLIER != null ? MENU_TYPE_SUPPLIER.get() : null, containerId, playerInv, hand, 63);
        Item item;
        if (!this.chisel.isEmpty() && (item = this.chisel.getItem()) instanceof ItemChisel) {
            int targetSlot;
            int playerSlotIndex;
            ItemChisel itemChisel = (ItemChisel)item;
            int selectionSlot = itemChisel.getSelectionSlot(this.chisel);
            if (selectionSlot >= this.inventoryChisel.getContainerSize() && (playerSlotIndex = selectionSlot - this.inventoryChisel.getContainerSize()) >= 0 && playerSlotIndex < 36) {
                this.setSelection(this.getSlot(selectionSlot));
            }
            if ((targetSlot = itemChisel.getTargetSlot(this.chisel)) >= 0 && targetSlot < this.inventoryChisel.size) {
                this.setTarget(this.getSlot(targetSlot));
            }
        }
    }

    @Override
    protected int getSelectionLeft() {
        return 88;
    }

    @Override
    protected int getSelectionTop() {
        return 8;
    }

    @Override
    protected int getSelectionCols() {
        return 9;
    }

    @Override
    protected int getPlayerInvLeft() {
        return 88;
    }

    @Override
    protected int getPlayerInvTop() {
        return 138;
    }

    @Override
    protected int getHotbarTop() {
        return 196;
    }

    @Override
    public int getSelectionSize() {
        return 63;
    }

    public void setTarget(@Nullable Slot slot) {
        this.target = slot;
        Item item = this.chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setTargetSlot(this.chisel, slot != null ? slot.index : -1);
        }
    }

    public void setSelection(@Nullable Slot slot) {
        this.selection = slot;
        if (slot == null || !slot.hasItem()) {
            this.currentGroup = null;
            this.selectionDuplicates = ImmutableList.of();
            this.setTarget(null);
            this.inventoryChisel.setStackInSpecialSlot(ItemStack.EMPTY);
        } else {
            int playerInvStart;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = playerInvStart = this.inventoryChisel.getContainerSize(); i < this.slots.size(); ++i) {
                Slot s = this.getSlot(i);
                if (slot == s || !ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)s.getItem())) continue;
                builder.add((Object)s);
            }
            this.selectionDuplicates = builder.build();
            TagKey<Item> group = CarvingHelper.getCarvingGroupForItem(slot.getItem());
            if (this.currentGroup != null && group != this.currentGroup) {
                this.setTarget(null);
            }
            this.currentGroup = group;
            this.inventoryChisel.setStackInSpecialSlot(slot.getItem().copy());
        }
        this.inventoryChisel.updateItems();
        Item item = this.chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setSelectionSlot(this.chisel, slot != null ? slot.index : -1);
        }
    }

    @Nullable
    public Slot getSelection() {
        return this.selection;
    }

    @Nullable
    public Slot getTarget() {
        return this.target;
    }

    public List<Slot> getSelectionDuplicates() {
        return this.selectionDuplicates;
    }

    @Nullable
    public ItemStack getSelectionStack() {
        return this.selection != null ? this.selection.getItem() : ItemStack.EMPTY;
    }

    public ItemStack getTargetItem() {
        return this.target != null ? this.target.getItem() : ItemStack.EMPTY;
    }

    @Override
    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            Slot slot = this.getSlot(slotId);
            if (slotId < this.inventoryChisel.size) {
                this.setTarget(slot);
            } else if (slotId > this.inventoryChisel.size) {
                if (dragType == 1) {
                    ItemStack toFind = slot.getItem();
                    if (!toFind.isEmpty()) {
                        for (int i = 0; i < this.inventoryChisel.size; ++i) {
                            if (!ItemStack.isSameItem((ItemStack)toFind, (ItemStack)this.inventoryChisel.getItem(i))) continue;
                            this.setTarget(this.getSlot(i));
                            break;
                        }
                    }
                } else if (slot.hasItem() && CarvingHelper.canChisel(slot.getItem())) {
                    this.setSelection(slot);
                }
            }
        }
    }

    @Override
    public void removed(Player player) {
        Item item = this.chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setTarget(this.chisel, this.getTargetItem());
        }
        this.inventoryChisel.setStackInSpecialSlot(ItemStack.EMPTY);
        super.removed(player);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIdx) {
        return ItemStack.EMPTY;
    }

    public void chiselSlots(int[] slots) {
        if (this.target == null || !this.target.hasItem()) {
            return;
        }
        if (this.selection == null || !this.selection.hasItem()) {
            return;
        }
        Item item = this.chisel.getItem();
        if (!(item instanceof IChiselItem)) {
            return;
        }
        IChiselItem chiselItem = (IChiselItem)item;
        ItemStack targetStack = this.target.getItem();
        boolean chiseledAny = false;
        for (int slotIndex : slots) {
            ItemStack source;
            Slot slot = this.getSlot(slotIndex);
            if (slot == null || !slot.hasItem() || !CarvingHelper.canChisel(source = slot.getItem())) continue;
            TagKey<Item> sourceGroup = CarvingHelper.getCarvingGroupForItem(source);
            TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(targetStack);
            if (sourceGroup == null || !sourceGroup.equals(targetGroup)) continue;
            ItemStack converted = targetStack.copy();
            converted.setCount(source.getCount());
            slot.set(converted);
            chiseledAny = true;
            chiselItem.onChisel(this.inventoryPlayer.player.level(), this.inventoryPlayer.player, this.chisel, Blocks.AIR);
            if (!this.chisel.isEmpty()) continue;
            this.inventoryPlayer.setItem(this.chiselSlot, ItemStack.EMPTY);
            break;
        }
        if (chiseledAny) {
            CarvingHelper.playChiselSound(this.inventoryPlayer.player.level(), this.inventoryPlayer.player);
        }
        if (this.selection != null && !this.selection.hasItem()) {
            if (!this.selectionDuplicates.isEmpty()) {
                this.setSelection(this.selectionDuplicates.get(0));
            } else {
                this.setSelection(null);
            }
        } else if (this.selection != null) {
            this.setSelection(this.selection);
        }
        this.broadcastChanges();
    }
}

