/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryChiselSelection
implements Container {
    public final int size;
    public int activeVariations = 0;
    @Nullable
    ChiselMenu container;
    NonNullList<ItemStack> inventory;

    public InventoryChiselSelection(ChiselMenu container, int size) {
        this.size = size;
        this.container = container;
        this.inventory = NonNullList.withSize((int)(size + 1), (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return this.size + 1;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            if (stack.getCount() <= amount) {
                this.setItem(slot, ItemStack.EMPTY);
                return stack;
            }
            ItemStack split = stack.split(amount);
            if (stack.getCount() == 0) {
                this.setItem(slot, ItemStack.EMPTY);
            }
            return split;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(slot);
        this.inventory.set(slot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        IChiselItem chiselItem;
        Item item;
        if (this.container == null) {
            return false;
        }
        ItemStack held = player.getInventory().getItem(this.container.getChiselSlot());
        return !held.isEmpty() && (item = held.getItem()) instanceof IChiselItem && (chiselItem = (IChiselItem)item).canOpenGui(player.level(), player, this.container.getHand());
    }

    public void clearContent() {
        this.inventory.clear();
        for (int i = 0; i < this.size + 1; ++i) {
            this.inventory.add((Object)ItemStack.EMPTY);
        }
    }

    public ItemStack getStackInSpecialSlot() {
        return (ItemStack)this.inventory.get(this.size);
    }

    public void setStackInSpecialSlot(ItemStack stack) {
        this.setItem(this.size, stack);
    }

    public void clearItems() {
        this.activeVariations = 0;
        for (int i = 0; i < this.size; ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public void updateItems() {
        ItemStack target = this.getStackInSpecialSlot();
        this.clearItems();
        if (target.isEmpty()) {
            return;
        }
        TagKey<Item> group = CarvingHelper.getCarvingGroupForItem(target);
        if (group == null) {
            return;
        }
        List<Item> variations = CarvingHelper.getItemsInGroup(group);
        this.activeVariations = 0;
        for (Item item : variations) {
            if (this.activeVariations >= this.size) break;
            this.setItem(this.activeVariations, new ItemStack((ItemLike)item));
            ++this.activeVariations;
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot != this.size) {
            return false;
        }
        return CarvingHelper.canChisel(stack);
    }
}

