/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.compat.ftbultimine.FTBUltimineHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class ChiselController {
    private static final LoadingCache<Player, Long> CLICK_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).weakKeys().build((CacheLoader)new CacheLoader<Player, Long>(){

        public Long load(Player key) {
            return 0L;
        }
    });

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack held = event.getItemStack();
        Item item = held.getItem();
        if (!(item instanceof IChiselItem)) {
            return;
        }
        IChiselItem chisel = (IChiselItem)item;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction side = event.getFace();
        BlockState state = level.getBlockState(pos);
        if (!chisel.canChiselBlock(level, player, event.getHand(), pos, state)) {
            return;
        }
        TagKey<Item> blockGroup = CarvingHelper.getCarvingGroupForBlock(state.getBlock());
        if (blockGroup == null) {
            return;
        }
        Iterable<? extends BlockPos> candidates = ChiselController.getCandidates(player, pos, side, chisel.getMode(held));
        ItemStack target = chisel.getTarget(held);
        if (!target.isEmpty()) {
            Block targetBlock;
            TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(target);
            if (blockGroup.equals(targetGroup) && (targetBlock = Block.byItem((Item)target.getItem())) != null) {
                ChiselController.setAll(candidates, player, state, targetBlock, held, event.getHand());
                event.setCanceled(true);
            }
        } else {
            List<Item> variations = CarvingHelper.getItemsInGroup(blockGroup);
            if (variations.isEmpty()) {
                return;
            }
            int index = -1;
            for (int i = 0; i < variations.size(); ++i) {
                if (Block.byItem((Item)variations.get(i)) != state.getBlock()) continue;
                index = i;
                break;
            }
            index = player.isCrouching() ? index - 1 : index + 1;
            Block nextBlock = Block.byItem((Item)variations.get(index = (index + variations.size()) % variations.size()));
            if (nextBlock != null) {
                ChiselController.setAll(candidates, player, state, nextBlock, held, event.getHand());
                event.setCanceled(true);
            }
        }
    }

    private static void setAll(Iterable<? extends BlockPos> candidates, Player player, BlockState origState, Block targetBlock, ItemStack chisel, InteractionHand hand) {
        if (!ChiselController.checkClickCache(player)) {
            return;
        }
        for (BlockPos blockPos : candidates) {
            ChiselController.setVariation(player, blockPos, origState, targetBlock, chisel, hand);
        }
    }

    private static boolean checkClickCache(Player player) {
        long time = player.level().getGameTime();
        if ((Long)CLICK_CACHE.getUnchecked((Object)player) > time - 2L) {
            return false;
        }
        CLICK_CACHE.put((Object)player, (Object)time);
        return true;
    }

    private static void setVariation(Player player, BlockPos pos, BlockState origState, Block targetBlock, ItemStack chiselStack, InteractionHand hand) {
        Level level = player.level();
        BlockState curState = level.getBlockState(pos);
        if (curState.getBlock() == targetBlock) {
            return;
        }
        if (origState != curState) {
            return;
        }
        Item item = chiselStack.getItem();
        if (item instanceof IChiselItem) {
            IChiselItem chisel = (IChiselItem)item;
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            chisel.onChisel(level, player, chiselStack, targetBlock);
            if (chiselStack.isEmpty() || chiselStack.getCount() <= 0) {
                ItemStack targetItem = chisel.getTarget(chiselStack);
                player.getInventory().setItem(player.getInventory().selected, targetItem.isEmpty() ? ItemStack.EMPTY : targetItem);
                return;
            }
            if (level.isClientSide) {
                CarvingHelper.playChiselSound(level, player, targetBlock);
                level.levelEvent(player, 2001, pos, Block.getId((BlockState)origState));
            }
            level.setBlockAndUpdate(pos, targetBlock.defaultBlockState());
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack mainhandStack;
        if (event.getHand() == InteractionHand.OFF_HAND && (mainhandStack = event.getEntity().getMainHandItem()).getItem() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().getMainHandItem();
        if (event.getPlayer().getAbilities().instabuild && !stack.isEmpty() && stack.getItem() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    private static Iterable<? extends BlockPos> getCandidates(Player player, BlockPos pos, Direction side, IChiselMode mode) {
        Optional<Collection<BlockPos>> ultimineSelection;
        if (ChiselConfig.enableUltimineCompat && ModList.get().isLoaded("ftbultimine") && (ultimineSelection = FTBUltimineHelper.getBlockSelection(player)).isPresent()) {
            return ultimineSelection.get();
        }
        return mode.getCandidates(player, pos, side);
    }
}

