/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.server;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChiselButtonPayload(int[] slotIds) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChiselButtonPayload> TYPE = new CustomPacketPayload.Type(Chisel.id("chisel_button"));
    public static final StreamCodec<FriendlyByteBuf, ChiselButtonPayload> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ChiselButtonPayload>(){

        public ChiselButtonPayload decode(FriendlyByteBuf buf) {
            return new ChiselButtonPayload(buf.readVarIntArray());
        }

        public void encode(FriendlyByteBuf buf, ChiselButtonPayload payload) {
            buf.writeVarIntArray(payload.slotIds);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ChiselButtonPayload.chiselAll((Player)player, this.slotIds);
            }
        });
    }

    public static void chiselAll(Player player, int[] slots) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof HitechChiselMenu)) {
            return;
        }
        HitechChiselMenu menu = (HitechChiselMenu)abstractContainerMenu;
        ItemStack chisel = menu.getChisel();
        ItemStack target = menu.getTargetItem();
        if (!(chisel.getItem() instanceof IChiselItem)) {
            return;
        }
        if (chisel.isEmpty() || target.isEmpty()) {
            return;
        }
        TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(target);
        if (targetGroup == null) {
            return;
        }
        boolean chiseledAny = false;
        for (int menuSlotIndex : slots) {
            TagKey<Item> stackGroup;
            Slot slot;
            ItemStack stack;
            if (menuSlotIndex < 0 || menuSlotIndex >= menu.slots.size() || (stack = (slot = menu.getSlot(menuSlotIndex)).getItem()).isEmpty() || (stackGroup = CarvingHelper.getCarvingGroupForItem(stack)) == null || !stackGroup.equals(targetGroup)) continue;
            ItemStack result = new ItemStack((ItemLike)target.getItem(), stack.getCount());
            slot.set(result);
            chiseledAny = true;
            if (!chisel.isDamageableItem()) continue;
            chisel.setDamageValue(chisel.getDamageValue() + 1);
            if (chisel.getDamageValue() >= chisel.getMaxDamage()) break;
        }
        if (chiseledAny) {
            CarvingHelper.playChiselSound(player.level(), player);
        }
    }
}

