/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.well_greased.config;

import java.util.function.Function;

public enum EasingFunction {
    LINEAR("Linear", t -> t),
    EASE_IN("Ease In", t -> Float.valueOf(1.0f - (float)Math.cos((double)t.floatValue() * Math.PI / 2.0))),
    EASE_OUT("Ease Out", t -> Float.valueOf((float)Math.sin((double)t.floatValue() * Math.PI / 2.0))),
    EASE_IN_OUT("Ease In Out", t -> Float.valueOf((float)(0.5 * (1.0 - Math.cos((double)t.floatValue() * Math.PI)))));

    private final String name;
    private final Function<Float, Float> function;

    private EasingFunction(String name, Function<Float, Float> function) {
        this.name = name;
        this.function = function;
    }

    public String toString() {
        return this.name;
    }

    public float apply(float t) {
        return this.function.apply(Float.valueOf(this.clamp(t))).floatValue();
    }

    private float clamp(float t) {
        return Math.max(0.0f, Math.min(1.0f, t));
    }
}

