/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.well_greased.particle;

import com.gaura.well_greased.particle.DoorParticle;
import com.gaura.well_greased.particle.FenceGateLeftParticle;
import com.gaura.well_greased.particle.FenceGateRightParticle;
import com.gaura.well_greased.particle.LeverBaseParticle;
import com.gaura.well_greased.particle.LeverHandleParticle;
import com.gaura.well_greased.particle.TrapdoorParticle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_703;

public class BlockParticleManager {
    private static final Map<class_2338, DoorParticle> DOOR_PARTICLES = new HashMap<class_2338, DoorParticle>();
    private static final Map<class_2338, TrapdoorParticle> TRAPDOOR_PARTICLES = new HashMap<class_2338, TrapdoorParticle>();
    private static final Map<class_2338, LeverBaseParticle> LEVER_BASE_PARTICLES = new HashMap<class_2338, LeverBaseParticle>();
    private static final Map<class_2338, LeverHandleParticle> LEVER_HANDLE_PARTICLES = new HashMap<class_2338, LeverHandleParticle>();
    private static final Map<class_2338, FenceGateLeftParticle> FENCE_GATE_LEFT_PARTICLES = new HashMap<class_2338, FenceGateLeftParticle>();
    private static final Map<class_2338, FenceGateRightParticle> FENCE_GATE_RIGHT_PARTICLES = new HashMap<class_2338, FenceGateRightParticle>();
    private static final Set<class_2338> INVISIBLE_BLOCKS = new CopyOnWriteArraySet<class_2338>();

    public static void addDoorAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        DoorParticle doorParticle = new DoorParticle(clientWorld, blockPos, blockState);
        DoorParticle previousDoorParticle = DOOR_PARTICLES.put(blockPos, doorParticle);
        if (previousDoorParticle != null && previousDoorParticle.method_3086()) {
            doorParticle.setAge(previousDoorParticle.getAge());
            previousDoorParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)doorParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, blockState);
    }

    public static void addTrapdoorAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        TrapdoorParticle trapdoorParticle = new TrapdoorParticle(clientWorld, blockPos, blockState);
        TrapdoorParticle previousTrapdoorParticle = TRAPDOOR_PARTICLES.put(blockPos, trapdoorParticle);
        if (previousTrapdoorParticle != null && previousTrapdoorParticle.method_3086()) {
            trapdoorParticle.setAge(previousTrapdoorParticle.getAge());
            previousTrapdoorParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)trapdoorParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, blockState);
    }

    public static void addFenceGateLeftAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 oldBlockState, class_2680 newBlockState) {
        FenceGateLeftParticle fenceGateLeftParticle = new FenceGateLeftParticle(clientWorld, blockPos, oldBlockState, newBlockState);
        FenceGateLeftParticle previousFenceGateLeftParticle = FENCE_GATE_LEFT_PARTICLES.put(blockPos, fenceGateLeftParticle);
        if (previousFenceGateLeftParticle != null && previousFenceGateLeftParticle.method_3086()) {
            fenceGateLeftParticle.setAge(previousFenceGateLeftParticle.getAge());
            previousFenceGateLeftParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)fenceGateLeftParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, oldBlockState);
    }

    public static void addFenceGateRightAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 oldBlockState, class_2680 newBlockState) {
        FenceGateRightParticle fenceGateRightParticle = new FenceGateRightParticle(clientWorld, blockPos, oldBlockState, newBlockState);
        FenceGateRightParticle previousFenceGateRightParticle = FENCE_GATE_RIGHT_PARTICLES.put(blockPos, fenceGateRightParticle);
        if (previousFenceGateRightParticle != null && previousFenceGateRightParticle.method_3086()) {
            fenceGateRightParticle.setAge(previousFenceGateRightParticle.getAge());
            previousFenceGateRightParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)fenceGateRightParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, oldBlockState);
    }

    public static void addLeverBaseAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        LeverBaseParticle leverBaseParticle = new LeverBaseParticle(clientWorld, blockPos, blockState);
        LeverBaseParticle previousLeverBaseParticle = LEVER_BASE_PARTICLES.put(blockPos, leverBaseParticle);
        if (previousLeverBaseParticle != null && previousLeverBaseParticle.method_3086()) {
            leverBaseParticle.setAge(previousLeverBaseParticle.getAge());
            previousLeverBaseParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)leverBaseParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, blockState);
    }

    public static void addLeverHandleAnimation(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        LeverHandleParticle leverHandleParticle = new LeverHandleParticle(clientWorld, blockPos, blockState);
        LeverHandleParticle previousLeverHandleParticle = LEVER_HANDLE_PARTICLES.put(blockPos, leverHandleParticle);
        if (previousLeverHandleParticle != null && previousLeverHandleParticle.method_3086()) {
            leverHandleParticle.setAge(previousLeverHandleParticle.getAge());
            previousLeverHandleParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)leverHandleParticle);
        BlockParticleManager.setBlockInvisible(clientWorld, blockPos, blockState);
    }

    public static void setBlockInvisible(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        if (INVISIBLE_BLOCKS.add(blockPos)) {
            BlockParticleManager.updateBlock(clientWorld, blockPos, blockState);
        }
    }

    public static void setBlockVisible(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        if (INVISIBLE_BLOCKS.remove(blockPos)) {
            BlockParticleManager.updateBlock(clientWorld, blockPos, blockState);
        }
    }

    public static boolean isBlockInvisible(class_2338 blockPos) {
        return INVISIBLE_BLOCKS.contains(blockPos);
    }

    private static void updateBlock(class_638 clientWorld, class_2338 blockPos, class_2680 blockState) {
        clientWorld.method_8413(blockPos, blockState, blockState, 2);
    }
}

